/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.BitFontRenderer;
import controlP5.CDrawable;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.ControllerInterface;
import controlP5.ControllerStyle;
import processing.core.PApplet;
import processing.core.PFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Label
implements CDrawable {
    protected int _myLetterSpacing = 0;
    protected boolean isMultiline;
    protected boolean isFixedSize;
    protected ControllerStyle _myControllerStyle = new ControllerStyle();
    protected boolean isVisible = true;
    protected int _myColor = -1;
    protected boolean isColorBackground;
    protected boolean isToUpperCase = true;
    protected boolean changed;
    protected int _myColorBackground = -1;
    protected int _myHeight = -1;
    protected int _myWidth = -1;
    protected String _myText = "";
    protected ControlFont _myFontLabel;
    protected int _myLineHeight = 0;
    protected int alignX = 37;
    protected int alignY = 37;
    public static int paddingX = 4;
    public static int paddingY = 4;
    public int _myPaddingX = paddingX;
    public int _myPaddingY = paddingY;
    protected Labeltype _myLabeltype;
    protected int _myTextHeight = 1;
    protected float offsetYratio = 0.0f;

    private Label(Label label) {
        this._myText = label.getText();
        this.isToUpperCase = label.isToUpperCase();
        this._myLetterSpacing = label.getLetterSpacing();
        this._myLineHeight = label.getLineHeight();
        this._myFontLabel = label.getFont();
        this._myLabeltype = label.getLabeltype();
    }

    public Label(ControlP5 controlP5, String string) {
        this.init(controlP5, string, 0, 0, this._myColor);
    }

    public Label(ControlP5 controlP5, String string, int n, int n2, int n3) {
        this.init(controlP5, string, n, n2, n3);
    }

    private void init(ControlP5 controlP5, String string, int n, int n2, int n3) {
        this._myWidth = n;
        this._myHeight = n2;
        this._myText = string;
        this._myColor = n3;
        this.setLabeltype(new SinglelineLabel());
        if (controlP5.isControlFont && controlP5.getFont() != null) {
            this.setFont(controlP5.getFont());
        } else {
            this.setFont(ControlP5.bitFont);
            this.setLineHeight(BitFontRenderer.getHeight(ControlP5.bitFont));
            int[] nArray = BitFontRenderer.getDimension(this, (ControlFont.BitFontLabel)this._myFontLabel.get(), this.getTextFormatted());
            this.setWidth(n != 0 ? n : nArray[0]);
            this.setHeight(n2 != 0 ? n2 : nArray[1]);
        }
        this.setLabeltype(new SinglelineLabel());
        this.set(this._myText);
        this._myControllerStyle = new ControllerStyle();
    }

    Label setLabeltype(Labeltype labeltype) {
        this._myLabeltype = labeltype;
        return this;
    }

    Labeltype getLabeltype() {
        return this._myLabeltype;
    }

    public Label align(int[] nArray) {
        this.alignX = nArray[0];
        this.alignY = nArray[1];
        return this;
    }

    public Label align(int n, int n2) {
        this.alignX = n;
        this.alignY = n2;
        return this;
    }

    public Label alignX(int n) {
        this.alignX = n;
        return this;
    }

    public Label alignY(int n) {
        this.alignY = n;
        return this;
    }

    public int[] getAlign() {
        return new int[]{this.alignX, this.alignY};
    }

    public Label setPadding(int n, int n2) {
        this._myPaddingX = n;
        this._myPaddingY = n2;
        return this;
    }

    public Label setPaddingX(int n) {
        this._myPaddingX = n;
        return this;
    }

    public Label setPaddingY(int n) {
        this._myPaddingY = n;
        return this;
    }

    public void draw(PApplet pApplet, int n, int n2, ControllerInterface<?> controllerInterface) {
        if (this.isVisible) {
            this.getLabeltype().draw(this, pApplet, n, n2, controllerInterface);
        }
    }

    @Override
    public void draw(PApplet pApplet) {
        if (this.isVisible) {
            this._myFontLabel.adjust(pApplet, this);
            this.draw(pApplet, 0, 0);
        }
    }

    public void draw(PApplet pApplet, int n, int n2) {
        if (this.isVisible) {
            pApplet.pushMatrix();
            pApplet.translate((float)this._myControllerStyle.marginLeft, (float)this._myControllerStyle.marginTop);
            pApplet.translate((float)n, (float)n2);
            if (this.isColorBackground) {
                float f = this.getStyle().paddingRight + this.getStyle().paddingLeft;
                f = this.getStyle().backgroundWidth > -1 ? (f += (float)this._myControllerStyle.backgroundWidth) : (f += (float)this._myFontLabel.getWidth());
                float f2 = this.getStyle().paddingBottom + this.getStyle().paddingTop;
                f2 = this.getStyle().backgroundHeight > -1 ? (f2 += (float)this.getStyle().backgroundHeight) : (f2 += (float)this._myFontLabel.getHeight());
                pApplet.fill(this._myColorBackground);
                pApplet.rect(0.0f, 0.0f, f, f2);
            }
            pApplet.translate((float)this._myControllerStyle.paddingLeft, (float)this._myControllerStyle.paddingTop);
            this._myFontLabel.draw(pApplet, this);
            pApplet.popMatrix();
        }
    }

    public Label hide() {
        return this.setVisible(false);
    }

    public Label show() {
        return this.setVisible(true);
    }

    public Label setVisible(boolean bl) {
        this.isVisible = bl;
        return this;
    }

    public Label updateFont(ControlFont controlFont) {
        return this.setFont(controlFont);
    }

    public Label set(String string) {
        return this.setText(string);
    }

    public Label setText(String string) {
        this._myText = string;
        this.setChanged(true);
        return this;
    }

    public Label setFixedSize(boolean bl) {
        this.isFixedSize = bl;
        return this;
    }

    public boolean isFixedSize() {
        return this.isMultiline ? false : this.isFixedSize;
    }

    public String getText() {
        return this._myText;
    }

    public String getTextFormatted() {
        return this.getLabeltype().getTextFormatted();
    }

    public ControllerStyle getStyle() {
        return this._myControllerStyle;
    }

    public Label setWidth(int n) {
        this._myWidth = n;
        this.setChanged(true);
        return this;
    }

    public Label setHeight(int n) {
        this._myHeight = n;
        this.setChanged(true);
        return this;
    }

    public int getWidth() {
        return this._myLabeltype.getWidth();
    }

    public int getHeight() {
        return this._myLabeltype.getHeight();
    }

    public int getOverflow() {
        return this.getLabeltype().getOverflow();
    }

    public Label setMultiline(boolean bl) {
        this.isMultiline = bl;
        this._myLabeltype = this.isMultiline ? new MultilineLabel() : new SinglelineLabel();
        return this;
    }

    public Label toUpperCase(boolean bl) {
        this.isToUpperCase = bl;
        this.setChanged(true);
        return this;
    }

    public ControlFont getFont() {
        return this._myFontLabel;
    }

    public Label setFont(int n) {
        this.setFont(new ControlFont(n));
        return this;
    }

    public Label setFont(PFont pFont) {
        return this.setFont(new ControlFont(pFont));
    }

    public Label setFont(ControlFont controlFont) {
        if (controlFont.get() instanceof ControlFont.BitFontLabel) {
            this.setLineHeight(BitFontRenderer.getHeight((ControlFont.BitFontLabel)controlFont.get()));
            this._myFontLabel = new ControlFont(((ControlFont.BitFontLabel)controlFont.get()).getFontIndex());
        } else {
            this.setLineHeight(((ControlFont.PFontLabel)controlFont.get()).getSize());
            ControlFont.PFontLabel pFontLabel = (ControlFont.PFontLabel)controlFont.get();
            this._myFontLabel = new ControlFont(pFontLabel.getFont(), pFontLabel.getSize());
        }
        this._myFontLabel.init(this);
        this.setChanged(true);
        return this;
    }

    public Label setSize(int n) {
        if (this._myFontLabel.get() instanceof ControlFont.PFontLabel) {
            ((ControlFont.PFontLabel)this._myFontLabel.get()).setSize(n);
        }
        return this;
    }

    protected boolean isChanged() {
        return this.changed;
    }

    protected Label setChanged(boolean bl) {
        this.changed = bl;
        return this;
    }

    Label setTextHeight(int n) {
        this._myTextHeight = n;
        return this;
    }

    public int getTextHeight() {
        return this._myFontLabel.get().getTextHeight();
    }

    public int getLineHeight() {
        return this._myLineHeight;
    }

    public Label setOffsetY(int n) {
        return this;
    }

    public Label setOffsetYratio(float f) {
        this.offsetYratio = f;
        this.setChanged(true);
        return this;
    }

    public float getOffsetYratio() {
        return this.offsetYratio;
    }

    public Label setLineHeight(int n) {
        this._myLineHeight = n;
        this.setChanged(true);
        return this;
    }

    public Label setColor(int n, boolean bl) {
        this.setColor(n);
        this.setFixedSize(bl);
        return this;
    }

    public Label setColor(int n) {
        this._myColor = n;
        this.setChanged(true);
        return this;
    }

    public int getColor() {
        return this._myColor;
    }

    public Label setColorBackground(int n) {
        this.enableColorBackground();
        this._myColorBackground = n;
        return this;
    }

    public Label disableColorBackground() {
        this.isColorBackground = false;
        return this;
    }

    public Label enableColorBackground() {
        this.isColorBackground = true;
        return this;
    }

    public int getLetterSpacing() {
        return this._myLetterSpacing;
    }

    public Label setLetterSpacing(int n) {
        this._myLetterSpacing = n;
        this.setChanged(true);
        return this;
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isToUpperCase() {
        return this.isToUpperCase;
    }

    protected Label copy() {
        return new Label(this);
    }

    @Deprecated
    public ControllerStyle style() {
        return this.getStyle();
    }

    @Deprecated
    public Label setControlFont(ControlFont controlFont) {
        return this.setFont(controlFont);
    }

    @Deprecated
    public Label setControlFontSize(int n) {
        System.out.println("Label.getControlFontSize has been deprecated");
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MultilineLabel
    implements Labeltype {
        MultilineLabel() {
        }

        @Override
        public void draw(Label label, PApplet pApplet, int n, int n2, ControllerInterface<?> controllerInterface) {
            Label.this._myFontLabel.adjust(pApplet, label);
            label.draw(pApplet, n, n2);
        }

        @Override
        public int getWidth() {
            return Label.this._myWidth;
        }

        @Override
        public int getHeight() {
            return Label.this._myHeight;
        }

        @Override
        public int getOverflow() {
            return Label.this._myFontLabel.get().getOverflow();
        }

        @Override
        public String getTextFormatted() {
            return Label.this.isToUpperCase ? Label.this._myText.toUpperCase() : Label.this._myText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SinglelineLabel
    implements Labeltype {
        SinglelineLabel() {
        }

        private void align(PApplet pApplet, ControllerInterface<?> controllerInterface, int n, int n2) {
            int n3 = 0;
            int n4 = 0;
            switch (n) {
                case 3: {
                    n3 = (controllerInterface.getWidth() - Label.this._myFontLabel.getWidth()) / 2;
                    break;
                }
                case 37: {
                    n3 = Label.this._myPaddingX;
                    break;
                }
                case 39: {
                    n3 = controllerInterface.getWidth() - Label.this._myFontLabel.getWidth() - Label.this._myPaddingX;
                    break;
                }
                case 10: {
                    n3 = -Label.this._myFontLabel.getWidth() - Label.this._myPaddingX;
                    break;
                }
                case 11: {
                    n3 = controllerInterface.getWidth() + Label.this._myPaddingX;
                }
            }
            switch (n2) {
                case 3: {
                    n4 = controllerInterface.getHeight() / 2 + Label.this._myFontLabel.get().getTop() - Label.this._myFontLabel.get().getCenter();
                    break;
                }
                case 101: {
                    n4 = 0;
                    break;
                }
                case 102: {
                    n4 = controllerInterface.getHeight() - Label.this._myFontLabel.get().getHeight() - 1;
                    break;
                }
                case 0: {
                    n4 = controllerInterface.getHeight() + Label.this._myFontLabel.get().getTop() - 1;
                    break;
                }
                case 13: {
                    n4 = controllerInterface.getHeight() + Label.this._myPaddingY;
                    break;
                }
                case 12: {
                    n4 = -Label.this._myFontLabel.getHeight() - Label.this._myPaddingY;
                }
            }
            pApplet.translate((float)n3, (float)n4);
        }

        @Override
        public void draw(Label label, PApplet pApplet, int n, int n2, ControllerInterface<?> controllerInterface) {
            Label.this._myFontLabel.adjust(pApplet, label);
            pApplet.pushMatrix();
            this.align(pApplet, controllerInterface, Label.this.alignX, Label.this.alignY);
            label.draw(pApplet, n, n2);
            pApplet.popMatrix();
        }

        @Override
        public int getWidth() {
            return Label.this.isFixedSize ? Label.this._myWidth : Label.this._myFontLabel.getWidth();
        }

        @Override
        public int getHeight() {
            return Label.this._myFontLabel.getHeight();
        }

        @Override
        public int getOverflow() {
            return -1;
        }

        @Override
        public String getTextFormatted() {
            return Label.this.isToUpperCase ? Label.this._myText.toUpperCase() : Label.this._myText;
        }
    }

    class SinglelineTextfield
    extends SinglelineLabel {
        SinglelineTextfield() {
        }

        public String getTextFormatted() {
            return Label.this._myText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Labeltype {
        public void draw(Label var1, PApplet var2, int var3, int var4, ControllerInterface<?> var5);

        public int getWidth();

        public int getHeight();

        public int getOverflow();

        public String getTextFormatted();
    }
}

