/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CallbackEvent;
import controlP5.ControlBroadcaster;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessControlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerPlug {
    private Object _myObject;
    private String _myName;
    private Method _myMethod;
    private Field _myField;
    private int _myType = -1;
    private Class<?> _myParameterClass;
    private int _myParameterType = -1;
    private Object _myValue = null;
    private Class<?>[] _myAcceptClassList;
    private Class<?> _myEventMethodParameter = ControlEvent.class;

    public ControllerPlug(Object object, String string, int n, int n2, Class<?>[] classArray) {
        this.set(object, string, n, n2, classArray);
    }

    ControllerPlug(Class<?> clazz, Object object, String string, int n, int n2) {
        this.setEventMethodParameter(clazz);
        this.set(object, string, n, n2, null);
    }

    void setEventMethodParameter(Class<?> clazz) {
        this._myEventMethodParameter = clazz;
    }

    protected void set(Object object) {
        this.set(object, this.getName(), this.getType(), this.getParameterType(), this.getAcceptClassList());
    }

    public void set(Object object, String string, int n, int n2, Class<?>[] classArray) {
        block24: {
            this._myObject = object;
            this._myName = string;
            this._myType = n;
            this._myParameterType = n2;
            this._myAcceptClassList = classArray;
            Class<?> clazz = object.getClass();
            if (this._myType == 0) {
                try {
                    Class[] classArray2;
                    Method[] methodArray = clazz.getDeclaredMethods();
                    block12: for (int i = 0; i < methodArray.length; ++i) {
                        if (!methodArray[i].getName().equals(string)) continue;
                        if (methodArray[i].getParameterTypes().length == 1) {
                            for (int j = 0; j < this._myAcceptClassList.length; ++j) {
                                if (methodArray[i].getParameterTypes()[0] != this._myAcceptClassList[j]) continue;
                                this._myParameterClass = methodArray[i].getParameterTypes()[0];
                                break block12;
                            }
                            break;
                        }
                        if (methodArray[i].getParameterTypes().length != 0) break;
                        this._myParameterClass = null;
                        break;
                    }
                    if (this._myParameterClass == null) {
                        classArray2 = new Class[]{};
                    } else {
                        Class[] classArray3 = new Class[1];
                        classArray2 = classArray3;
                        classArray3[0] = this._myParameterClass;
                    }
                    Class[] classArray4 = classArray2;
                    this._myMethod = clazz.getDeclaredMethod(this._myName, classArray4);
                    this._myMethod.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    this.printSecurityWarning(securityException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (this._myParameterClass != CallbackEvent.class) {
                        ControlP5.logger().warning(" plug() failed. If function " + string + " does exist, make it public. " + noSuchMethodException);
                    }
                    break block24;
                }
            }
            if (this._myType == 2) {
                try {
                    this._myMethod = this._myObject.getClass().getMethod(this._myName, this._myEventMethodParameter);
                    this._myMethod.setAccessible(true);
                    this._myParameterClass = this._myEventMethodParameter;
                }
                catch (SecurityException securityException) {
                    this.printSecurityWarning(securityException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (this._myEventMethodParameter != CallbackEvent.class) {
                        ControlP5.logger().warning(" plug() failed " + this._myParameterClass + ". If function " + string + " does exist, make it public. " + noSuchMethodException);
                    }
                    break block24;
                }
            }
            if (this._myType == 1) {
                Field[] fieldArray = ControlBroadcaster.getFieldsFor(clazz);
                for (int i = 0; i < fieldArray.length; ++i) {
                    if (!fieldArray[i].getName().equals(this._myName)) continue;
                    this._myParameterClass = fieldArray[i].getType();
                }
                if (this._myParameterClass != null) {
                    try {
                        this._myField = clazz.getDeclaredField(this._myName);
                        try {
                            this._myField.setAccessible(true);
                        }
                        catch (AccessControlException accessControlException) {
                            this.printSecurityWarning(accessControlException);
                        }
                        try {
                            this._myValue = this._myField.get(object);
                        }
                        catch (Exception exception) {
                            this.printSecurityWarning(exception);
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        ControlP5.logger().warning(noSuchFieldException.toString());
                    }
                }
            }
        }
    }

    private void printSecurityWarning(Exception exception) {
        if (exception.getClass().equals(AccessControlException.class)) {
            ControlP5.isApplet = true;
            ControlP5.logger().warning("You are probably running in applet mode.\nmake sure fields and methods in your code are public.\n" + exception);
        }
    }

    protected Object getValue() {
        return this._myValue;
    }

    protected Object getObject() {
        return this._myObject;
    }

    protected String getName() {
        return this._myName;
    }

    protected int getType() {
        return this._myType;
    }

    protected int getParameterType() {
        return this._myParameterType;
    }

    protected Class<?>[] getAcceptClassList() {
        return this._myAcceptClassList;
    }

    protected Class<?> getClassType() {
        return this._myParameterClass;
    }

    protected boolean checkType(int n) {
        return this._myType == n;
    }

    protected boolean checkName(String string) {
        return this._myName.equals(string);
    }

    private Object get(float f) {
        if (this._myParameterClass == Float.TYPE) {
            return new Float(f);
        }
        if (this._myParameterClass == Integer.TYPE) {
            return new Integer((int)f);
        }
        if (this._myParameterClass == Boolean.TYPE) {
            return (double)f > 0.5 ? new Boolean(true) : new Boolean(false);
        }
        return null;
    }

    protected Object getFieldParameter(float f) {
        return this.get(f);
    }

    protected Object[] getMethodParameter(float f) {
        return new Object[]{this.get(f)};
    }

    protected Method getMethod() {
        return this._myMethod;
    }

    protected Field getField() {
        return this._myField;
    }

    public static boolean checkPlug(Object object, String string, Class<?>[] classArray) {
        try {
            object.getClass().getDeclaredMethod(string, classArray);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Deprecated
    protected Class<?> classType() {
        return this._myParameterClass;
    }

    @Deprecated
    protected Object value() {
        return this._myValue;
    }

    @Deprecated
    protected Object object() {
        return this._myObject;
    }

    @Deprecated
    protected String name() {
        return this._myName;
    }

    @Deprecated
    protected int type() {
        return this._myType;
    }

    @Deprecated
    protected int parameterType() {
        return this._myParameterType;
    }

    @Deprecated
    protected Class<?>[] acceptClassList() {
        return this._myAcceptClassList;
    }
}

