/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.CallbackEvent;
import controlP5.CallbackListener;
import controlP5.ControlBehavior;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlGroup;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlP5IOHandler;
import controlP5.ControlWindow;
import controlP5.ControllerDisplay;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerPlug;
import controlP5.ControllerProperty;
import controlP5.ControllerSprite;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.Pointer;
import controlP5.Tab;
import controlP5.Textfield;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Controller<T>
implements ControllerInterface<T>,
CDrawable,
ControlP5Constants {
    protected PVector position = new PVector();
    protected PVector positionBuffer = new PVector();
    protected PVector absolutePosition = new PVector();
    protected ControllerInterface<?> _myParent;
    protected final String _myName;
    protected ControlWindow _myControlWindow;
    protected boolean isMousePressed = false;
    protected ControlP5 cp5;
    protected int width;
    protected int height;
    protected int _myId = -1;
    protected float _myValue = Float.NaN;
    protected float _myDefaultValue = Float.NaN;
    protected String _myStringValue = "";
    protected float[] _myArrayValue;
    protected Label _myCaptionLabel;
    protected Label _myValueLabel;
    protected boolean isLabelVisible = true;
    protected boolean isMoveable = true;
    protected boolean isBroadcast = true;
    protected boolean isVisible = true;
    protected boolean isActive = false;
    protected boolean isLock = false;
    protected boolean isUserInteraction = true;
    protected boolean isInit = false;
    protected List<ControlListener> _myControlListener;
    protected CColor color = new CColor();
    protected float _myMin;
    protected float _myMax;
    protected float _myUnit;
    protected String target;
    protected Object targetObject;
    protected ControlBehavior _myBehavior;
    protected boolean isBehavior;
    protected List<Controller<?>> subelements;
    protected int _myBroadcastType = 2;
    protected boolean isUpdate = false;
    protected int _myDecimalPoints = 2;
    protected boolean isSprite;
    public static int autoWidth = 49;
    public static int autoHeight = 19;
    public static PVector autoSpacing = new PVector(10.0f, 10.0f, 0.0f);
    protected boolean[] availableImages = new boolean[4];
    protected PImage[] images = new PImage[4];
    protected ControllerView<T> _myControllerView;
    protected ControllerView<T> _myDebugView;
    protected int _myDisplayMode = 0;
    protected int _myPickingColor = -256;
    protected boolean mouseover;
    protected String _myAddress = "";
    protected List<ControllerPlug> _myControllerPlugList;
    protected boolean tooltipEnabled;
    protected boolean listening;
    protected boolean isInside = false;
    private T me;
    protected boolean dragged;
    protected ControllerSprite sprite;

    public Controller(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 0.0f, autoWidth, autoHeight);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected Controller(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, float f2, int n, int n2) {
        this.cp5 = controlP5;
        this.me = this;
        if (this.cp5 == null) {
            this.isBroadcast = false;
        }
        this._myName = string;
        this.position = new PVector(f, f2, 0.0f);
        this.positionBuffer = new PVector(f, f2, 0.0f);
        this.setParent(controllerGroup);
        if (controllerGroup != null) {
            this.color.set(controllerGroup.color);
        } else {
            this.color.set(ControlP5.color);
        }
        this.width = n;
        this.height = n2;
        this._myCaptionLabel = new Label(this.cp5, string);
        this._myCaptionLabel.setColor(this.color.getCaptionLabel());
        this._myValueLabel = new Label(this.cp5, "valueLabel");
        this._myControllerPlugList = new ArrayList<ControllerPlug>();
        this._myControlListener = new ArrayList<ControlListener>();
        this.subelements = new ArrayList();
        this._myArrayValue = new float[0];
        this._myDebugView = new DebugView();
        this.setView(this._myDebugView);
    }

    List<Controller<?>> getSubelements() {
        return this.subelements;
    }

    @Override
    @ControlP5.Layout
    public String getAddress() {
        return this._myAddress;
    }

    @Override
    @ControlP5.Invisible
    @ControlP5.Layout
    public T setAddress(String string) {
        if (this._myAddress.length() == 0) {
            this._myAddress = string;
        }
        return this.me;
    }

    protected Controller(ControlP5 controlP5, String string, float f, float f2, int n, int n2) {
        this(controlP5, controlP5.getTab("default"), string, f, f2, n, n2);
    }

    protected Controller(String string, int n, int n2) {
        this._myName = string;
        this.position = new PVector((float)n, (float)n2, 0.0f);
    }

    @Override
    @ControlP5.Invisible
    public void init() {
        this._myDefaultValue = this._myValue;
        this.cp5.getControlBroadcaster().plug((Object)this.cp5.papplet, this, this._myName);
        this.initControllerValue();
        this.isInit = this.cp5.isAutoInitialization;
        this.setValue(this._myDefaultValue);
        this.isInit = true;
        this.updateDisplayMode(0);
    }

    protected final void initControllerValue() {
        if (this._myValue == this.getMin() || Float.isNaN(this._myValue)) {
            if (this._myControllerPlugList.size() == 1) {
                if (this.getControllerPlugList().get(0).getValue() == null) {
                    this.setDefaultValue(this.getMin());
                } else {
                    float f = 0.0f;
                    if (this.getControllerPlugList().get(0).getValue() instanceof Boolean) {
                        boolean bl = new Boolean(this.getControllerPlugList().get(0).getValue().toString());
                        f = bl ? 1.0f : 0.0f;
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof Float) {
                        f = new Float(this.getControllerPlugList().get(0).getValue().toString()).floatValue();
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof Integer) {
                        f = new Integer(this.getControllerPlugList().get(0).getValue().toString()).intValue();
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof String) {
                        this._myStringValue = this.getControllerPlugList().get(0).getValue().toString();
                    }
                    this.setDefaultValue(f);
                }
            } else if (Float.isNaN(this.getDefaultValue())) {
                this.setDefaultValue(this.getMin());
            }
        }
        this._myValue = this._myDefaultValue;
    }

    protected void updateFont(ControlFont controlFont) {
        this._myCaptionLabel.updateFont(controlFont);
        this._myValueLabel.updateFont(controlFont);
    }

    public T setBehavior(ControlBehavior controlBehavior) {
        this.isBehavior = true;
        this._myBehavior = controlBehavior;
        this._myBehavior.init(this);
        return this.me;
    }

    public T removeBehavior() {
        this.isBehavior = false;
        this._myBehavior = null;
        return this.me;
    }

    public ControlBehavior getBehavior() {
        return this._myBehavior;
    }

    @ControlP5.Layout
    public float getDefaultValue() {
        return this._myDefaultValue;
    }

    @ControlP5.Layout
    public T setDefaultValue(float f) {
        this._myDefaultValue = f;
        return this.me;
    }

    @ControlP5.Layout
    public T setMoveable(boolean bl) {
        this.isMoveable = bl;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isMoveable() {
        return this.isMoveable;
    }

    @ControlP5.Layout
    public T setLabelVisible(boolean bl) {
        this.isLabelVisible = bl;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isLabelVisible() {
        return this.isLabelVisible;
    }

    @ControlP5.Layout
    public T setBroadcast(boolean bl) {
        this.isBroadcast = bl;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    @Override
    @ControlP5.Layout
    public PVector getPosition() {
        return this.position;
    }

    @Override
    @ControlP5.Layout
    public T setPosition(PVector pVector) {
        this.position.x = pVector.x;
        this.position.y = pVector.y;
        this.position.z = pVector.z;
        this.positionBuffer.x = pVector.x;
        this.positionBuffer.y = pVector.y;
        this.positionBuffer.z = pVector.z;
        return this.me;
    }

    @Override
    public T setPosition(float f, float f2) {
        this.position.x = f;
        this.position.y = f2;
        this.positionBuffer.x = this.position.x;
        this.positionBuffer.y = this.position.y;
        return this.me;
    }

    @Override
    public PVector getAbsolutePosition() {
        return this.absolutePosition;
    }

    @Override
    @ControlP5.Invisible
    public T setAbsolutePosition(PVector pVector) {
        this.absolutePosition.x = pVector.x;
        this.absolutePosition.y = pVector.y;
        this.absolutePosition.z = pVector.z;
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T updateAbsolutePosition() {
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public final void continuousUpdateEvents() {
        if (this.isBehavior && this._myBehavior.isActive() && !this.isMousePressed) {
            this._myBehavior.update();
        }
    }

    @Override
    @ControlP5.Invisible
    public final T updateEvents() {
        if (this.isInside) {
            boolean bl;
            boolean bl2 = bl = this._myControlWindow.mouseX - this._myControlWindow.pmouseX != 0 || this._myControlWindow.mouseY - this._myControlWindow.pmouseY != 0;
            if (this.isMousePressed) {
                if (bl) {
                    this.onDrag();
                    this.dragged = true;
                }
            } else if (bl && this.equals(this._myControlWindow.getFirstFromMouseOverList())) {
                this.onMove();
            }
        }
        if (this.isVisible && this.isMousePressed == this._myControlWindow.mouselock) {
            if (this.isMousePressed && this.cp5.keyHandler.isAltDown() && this.isMoveable) {
                if (!this.cp5.isMoveable) {
                    this.positionBuffer.x += (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX);
                    this.positionBuffer.y += (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
                    if (this.cp5.keyHandler.isShiftDown) {
                        this.position.x = (int)this.positionBuffer.x / 10 * 10;
                        this.position.y = (int)this.positionBuffer.y / 10 * 10;
                    } else {
                        this.position.set(this.positionBuffer);
                    }
                }
            } else if (!this.isLock) {
                if (this.isInside) {
                    this.setMouseOver(true);
                }
                if (this.inside()) {
                    if (!this.isInside) {
                        this.onEnter();
                        this.setIsInside(true);
                    }
                } else {
                    if (this.isInside && !this.isMousePressed) {
                        this.onLeave();
                        this.setMouseOver(false);
                        this.setIsInside(false);
                    }
                    if (!this.isInside && this.mouseover) {
                        this.setMouseOver(false);
                    }
                }
            }
        }
        return this.me;
    }

    public final Pointer getPointer() {
        return new Pointer(){

            public int x() {
                return (int)((float)Controller.this._myControlWindow.mouseX - Controller.this._myParent.getAbsolutePosition().x - Controller.this.position.x);
            }

            public int y() {
                return (int)((float)Controller.this._myControlWindow.mouseY - Controller.this._myParent.getAbsolutePosition().y - Controller.this.position.y);
            }

            public int px() {
                return (int)((float)Controller.this._myControlWindow.pmouseX - Controller.this._myParent.getAbsolutePosition().x - Controller.this.position.x);
            }

            public int py() {
                return (int)((float)Controller.this._myControlWindow.pmouseY - Controller.this._myParent.getAbsolutePosition().y - Controller.this.position.y);
            }
        };
    }

    @Override
    @ControlP5.Invisible
    public final boolean setMousePressed(boolean bl) {
        if (!this.isVisible && !this.isUserInteraction) {
            return false;
        }
        if (bl) {
            if (this.isInside) {
                this.isMousePressed = true;
                if (!this.cp5.keyHandler.isAltDown()) {
                    this.mousePressed();
                    this.onPress();
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 1));
                }
                return true;
            }
        } else {
            if (this.isMousePressed && this.inside()) {
                this.isMousePressed = false;
                if (!this.cp5.keyHandler.isAltDown()) {
                    if (!this.dragged) {
                        this.onClick();
                    }
                    this.mouseReleased();
                    this.onRelease();
                    this.dragged = false;
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 8));
                }
            }
            if (!this.inside()) {
                this.setIsInside(false);
                if (this.isMousePressed) {
                    this.isMousePressed = false;
                    this.mouseReleasedOutside();
                    this.onReleaseOutside();
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 16));
                }
                if (this instanceof Textfield) {
                    this.mouseReleasedOutside();
                    this.onReleaseOutside();
                }
            }
        }
        return false;
    }

    public T listen(boolean bl) {
        if (bl == this.listening) {
            return this.me;
        }
        this.listening = bl;
        if (this.listening) {
            this.cp5.listenTo(this._myName, this.cp5.getObjectForController(this));
        } else {
            this.cp5.stopListeningTo(this._myName, this.cp5.getObjectForController(this));
        }
        return this.me;
    }

    public boolean isListening() {
        return this.listening;
    }

    @Override
    public boolean isMouseOver() {
        return this.mouseover;
    }

    @Override
    public T setMouseOver(boolean bl) {
        if (this.mouseover == bl) {
            return this.me;
        }
        this.mouseover = bl;
        if (this.mouseover) {
            this._myControlWindow.setMouseOverController(this);
            this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 2));
            this.cp5.getTooltip().activate(this);
        } else {
            this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 4));
            this._myControlWindow.removeMouseOverFor(this);
            this.cp5.getTooltip().deactivate();
        }
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T updateInternalEvents(PApplet pApplet) {
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public void draw(PApplet pApplet) {
        pApplet.pushMatrix();
        pApplet.translate(this.position.x, this.position.y);
        this._myControllerView.display(pApplet, this.me);
        pApplet.popMatrix();
        pApplet.pushMatrix();
        pApplet.popMatrix();
    }

    @Override
    @ControlP5.Invisible
    public T add(ControllerInterface<?> controllerInterface) {
        ControlP5.logger().warning(" add() not supported.");
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T remove(ControllerInterface<?> controllerInterface) {
        ControlP5.logger().warning("remove() not supported.");
        return this.me;
    }

    @Override
    public void remove() {
        this._myControlWindow.removeMouseOverFor(this);
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.cp5 != null) {
            this.cp5.remove(this);
        }
    }

    @Override
    public T bringToFront() {
        return this.bringToFront(this);
    }

    @Override
    public T bringToFront(ControllerInterface<?> controllerInterface) {
        if (this._myParent instanceof Tab) {
            this.moveTo((Tab)this._myParent);
        } else {
            this._myParent.bringToFront(controllerInterface);
        }
        if (controllerInterface != this && this.getSubelements().contains(controllerInterface) && controllerInterface instanceof Controller) {
            this.getSubelements().remove(controllerInterface);
            this.getSubelements().add((Controller)controllerInterface);
        }
        return this.me;
    }

    @Override
    public String getName() {
        return this._myName;
    }

    public final T moveTo(String string) {
        this.setTab(string);
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(string);
        }
        return this.me;
    }

    public final T moveTo(Tab tab) {
        this.setTab(tab.getWindow(), tab.getName());
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(tab);
        }
        return this.me;
    }

    public final T moveTo(PApplet pApplet) {
        this.setTab("default");
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(pApplet);
        }
        return this.me;
    }

    public final T moveTo(PApplet pApplet, String string) {
        this.setTab(string);
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(pApplet, string);
        }
        return this.me;
    }

    public final T moveTo(ControlWindow controlWindow) {
        this.setTab(controlWindow, "default");
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(controlWindow);
        }
        return this.me;
    }

    public final T moveTo(ControlWindow controlWindow, String string) {
        this.setTab(controlWindow, string);
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(controlWindow, string);
        }
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> controllerGroup, Tab tab, ControlWindow controlWindow) {
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(controllerGroup, tab, controlWindow);
        }
        if (controllerGroup != null) {
            this.setGroup(controllerGroup);
            return this.me;
        }
        if (controlWindow == null) {
            controlWindow = this.cp5.controlWindow;
        }
        this.setTab(controlWindow, tab.getName());
        return this.me;
    }

    @Override
    public final T moveTo(ControlGroup<?> controlGroup) {
        if (controlGroup != null) {
            this.setGroup(controlGroup);
        }
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> controllerGroup) {
        if (controllerGroup != null) {
            this.setGroup(controllerGroup);
        }
        return this.me;
    }

    public final T setTab(String string) {
        this.setParent(this.cp5.getTab(string));
        for (Controller<?> controller : this.getSubelements()) {
            controller.setTab(string);
        }
        return this.me;
    }

    public final T setTab(ControlWindow controlWindow, String string) {
        this.setParent(this.cp5.getTab(controlWindow, string));
        for (Controller<?> controller : this.getSubelements()) {
            controller.setTab(controlWindow, string);
        }
        return this.me;
    }

    public final T setGroup(String string) {
        this.setParent(this.cp5.getGroup(string));
        for (Controller<?> controller : this.getSubelements()) {
            controller.setGroup(string);
        }
        return this.me;
    }

    public final T setGroup(ControllerGroup<?> controllerGroup) {
        this.setParent(controllerGroup);
        for (Controller<?> controller : this.getSubelements()) {
            controller.setGroup(controllerGroup);
        }
        return this.me;
    }

    @Override
    public Tab getTab() {
        if (this._myParent instanceof Tab) {
            return (Tab)this._myParent;
        }
        return this._myParent.getTab();
    }

    @ControlP5.Invisible
    public final T setParent(ControllerInterface<?> controllerInterface) {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        this.absolutePosition = new PVector(this.position.x, this.position.y);
        if (controllerInterface != null) {
            this._myParent = controllerInterface;
            this._myParent.add(this);
            this.absolutePosition.add(this._myParent.getPosition());
            this._myControlWindow = this._myParent.getWindow();
        }
        this.setMouseOver(false);
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    @ControlP5.Layout
    public ControllerInterface<?> getParent() {
        return this._myParent;
    }

    @Override
    public ControlWindow getWindow() {
        return this._myControlWindow;
    }

    protected boolean inside() {
        return (float)this._myControlWindow.mouseX > this.position.x + this._myParent.getAbsolutePosition().x && (float)this._myControlWindow.mouseX < this.position.x + this._myParent.getAbsolutePosition().x + (float)this.width && (float)this._myControlWindow.mouseY > this.position.y + this._myParent.getAbsolutePosition().y && (float)this._myControlWindow.mouseY < this.position.y + this._myParent.getAbsolutePosition().y + (float)this.height;
    }

    public boolean isInside() {
        return this.isInside;
    }

    @ControlP5.Layout
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isMousePressed() {
        return this.isMousePressed;
    }

    protected void onEnter() {
    }

    protected void onLeave() {
    }

    protected void onDrag() {
    }

    protected void onMove() {
    }

    protected void onClick() {
    }

    protected void onPress() {
    }

    protected void onRelease() {
    }

    protected void onScroll(int n) {
    }

    protected void onReleaseOutside() {
    }

    protected void mousePressed() {
    }

    protected void mouseReleased() {
    }

    protected void mouseReleasedOutside() {
    }

    protected void setIsInside(boolean bl) {
        this.isInside = bl;
    }

    protected boolean getIsInside() {
        return this.isInside;
    }

    @Override
    @ControlP5.Invisible
    public void keyEvent(KeyEvent keyEvent) {
    }

    @Override
    @ControlP5.Layout
    public T setId(int n) {
        this._myId = n;
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public int getId() {
        return this._myId;
    }

    protected ControllerPlug getControllerPlug(int n) {
        return this._myControllerPlugList.get(n);
    }

    public List<ControllerPlug> getControllerPlugList() {
        return this._myControllerPlugList;
    }

    protected boolean checkControllerPlug(ControllerPlug controllerPlug) {
        for (ControllerPlug controllerPlug2 : this._myControllerPlugList) {
            if (!controllerPlug2.getObject().equals(controllerPlug.getObject()) || !controllerPlug2.getName().equals(controllerPlug.getName())) continue;
            return true;
        }
        return false;
    }

    protected void addControllerPlug(ControllerPlug controllerPlug) {
        if (this.checkControllerPlug(controllerPlug)) {
            return;
        }
        this._myControllerPlugList.add(controllerPlug);
    }

    protected void removeControllerPlug(ControllerPlug controllerPlug) {
        this._myControllerPlugList.remove(controllerPlug);
    }

    public T plugTo(Object[] objectArray) {
        for (Object object : objectArray) {
            this.plugTo(object, this._myName);
        }
        return this.me;
    }

    public T plugTo(Object[] objectArray, String string) {
        for (Object object : objectArray) {
            this.plugTo(object, string);
        }
        return this.me;
    }

    public T plugTo(Object object) {
        return this.plugTo(object, this._myName);
    }

    public T plugTo(Object object, String string) {
        if (object instanceof PApplet) {
            this.unplugFrom(object);
        }
        this.cp5.getControlBroadcaster().plug(object, this, string);
        this.cp5.getControlBroadcaster().plug(object, this, this.cp5.getControlBroadcaster().getEventMethod());
        return this.me;
    }

    public T unplugFrom(Object[] objectArray) {
        for (Object object : objectArray) {
            this.unplugFrom(object);
        }
        return this.me;
    }

    public T unplugFrom(Object object) {
        Iterator<ControllerPlug> iterator = this._myControllerPlugList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getObject().equals(object)) continue;
            iterator.remove();
        }
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setValue(float f) {
        this._myValue = f;
        this.broadcast(2);
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public float getValue() {
        return this._myValue;
    }

    @Override
    @ControlP5.Layout
    public T setStringValue(String string) {
        this._myStringValue = string;
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public String getStringValue() {
        return this._myStringValue;
    }

    @Override
    @ControlP5.Layout
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    @Override
    public float getArrayValue(int n) {
        if (n >= 0 && n < this._myArrayValue.length) {
            return this._myArrayValue[n];
        }
        return Float.NaN;
    }

    @Override
    @ControlP5.Layout
    public T setArrayValue(float[] fArray) {
        this._myArrayValue = fArray;
        return this.me;
    }

    @Override
    public T setArrayValue(int n, float f) {
        if (n >= 0 && n < this._myArrayValue.length) {
            this._myArrayValue[n] = f;
        }
        return this.me;
    }

    public final T changeValue(float f) {
        boolean bl = this.isBroadcast;
        this.isBroadcast = false;
        this.setValue(f);
        this.isBroadcast = bl;
        return this.me;
    }

    @Override
    public T update() {
        return this.me;
    }

    @Override
    public T setUpdate(boolean bl) {
        this.isUpdate = bl;
        return this.me;
    }

    @Override
    public boolean isUpdate() {
        return this.isUpdate;
    }

    @Override
    @ControlP5.Invisible
    public int getPickingColor() {
        return this._myPickingColor;
    }

    @Override
    @ControlP5.Layout
    public CColor getColor() {
        return this.color;
    }

    @Override
    @ControlP5.Layout
    public T setCaptionLabel(String string) {
        this._myCaptionLabel.set(string);
        return this.me;
    }

    @ControlP5.Layout
    public T setValueLabel(String string) {
        this._myValueLabel.set(string);
        return this.me;
    }

    @ControlP5.Invisible
    public String getLabel() {
        return this._myCaptionLabel.getText();
    }

    @Override
    public T addListener(ControlListener controlListener) {
        this._myControlListener.add(controlListener);
        return this.me;
    }

    public T removeListener(ControlListener controlListener) {
        this._myControlListener.remove(controlListener);
        return this.me;
    }

    public int listenerSize() {
        return this._myControlListener.size();
    }

    public T addCallback(CallbackListener callbackListener) {
        this.cp5.addCallback(callbackListener, this);
        return this.me;
    }

    public T removeCallback(CallbackListener callbackListener) {
        this.cp5.removeCallback(callbackListener);
        return this.me;
    }

    public T removeCallback() {
        this.cp5.removeCallback((Controller<?>)this);
        return this.me;
    }

    protected void broadcast() {
        this.broadcast(this._myBroadcastType);
    }

    protected void broadcast(int n) {
        n = this._myBroadcastType;
        ControlEvent controlEvent = new ControlEvent(this);
        for (ControlListener controlListener : this._myControlListener) {
            controlListener.controlEvent(controlEvent);
        }
        if (this.isBroadcast && this.isInit) {
            this.cp5.getControlBroadcaster().broadcast(controlEvent, n);
            this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 32));
        }
        this.isInit = true;
    }

    @Override
    @ControlP5.Layout
    public boolean isVisible() {
        if (this.getParent() != null && !this.getParent().isVisible()) {
            return false;
        }
        return this.isVisible;
    }

    @ControlP5.Layout
    public T setVisible(boolean bl) {
        this.isVisible = bl;
        if (!bl) {
            this.isActive = false;
        }
        return this.me;
    }

    @Override
    public T hide() {
        this.setMouseOver(false);
        this.isVisible = false;
        this.isActive = false;
        return this.me;
    }

    @Override
    public T show() {
        this.isVisible = true;
        return this.me;
    }

    @Override
    public T setColor(CColor cColor) {
        this.color.set(cColor);
        this.setColorCaptionLabel(cColor.getCaptionLabel());
        this.setColorValueLabel(cColor.getValueLabel());
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setColorActive(int n) {
        this.color.setActive(n);
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setColorForeground(int n) {
        this.color.setForeground(n);
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setColorBackground(int n) {
        this.color.setBackground(n);
        return this.me;
    }

    @ControlP5.Layout
    public T setColorCaptionLabel(int n) {
        this.color.setCaptionLabel(n);
        this._myCaptionLabel.setColor(this.color.getCaptionLabel());
        return this.me;
    }

    @ControlP5.Layout
    public T setColorValueLabel(int n) {
        this.color.setValueLabel(n);
        if (this._myValueLabel != null) {
            this._myValueLabel.setColor(this.color.getValueLabel());
        }
        return this.me;
    }

    public T setImages(PImage pImage, PImage pImage2, PImage pImage3) {
        this.setImage(pImage, 0);
        this.setImage(pImage2, 1);
        this.setImage(pImage3, 2);
        this.setImage(pImage3, 3);
        return this.me;
    }

    public T setImages(PImage pImage, PImage pImage2, PImage pImage3, PImage pImage4) {
        this.setImage(pImage, 0);
        this.setImage(pImage2, 1);
        this.setImage(pImage3, 2);
        this.setImage(pImage4, 3);
        return this.me;
    }

    public T setImages(PImage ... pImageArray) {
        if (pImageArray.length < 3 || pImageArray.length > 4) {
            return this.me;
        }
        this.setImage(pImageArray[0], 0);
        this.setImage(pImageArray[1], 1);
        this.setImage(pImageArray[2], 2);
        this.setImage(pImageArray.length == 3 ? pImageArray[2] : pImageArray[3], 3);
        return this.me;
    }

    public T setImage(PImage pImage) {
        return this.setImage(pImage, 0);
    }

    public T setImage(PImage pImage, int n) {
        if (pImage != null) {
            this.images[n] = pImage;
            this.availableImages[n] = true;
            this.updateDisplayMode(1);
        }
        return this.me;
    }

    public T updateSize() {
        if (this.images[0] != null) {
            this.setSize(this.images[0]);
        }
        return this.me;
    }

    public T setSize(PImage pImage) {
        if (pImage != null) {
            this.setSize(pImage.width, pImage.height);
        }
        return this.me;
    }

    public T setSize(int n, int n2) {
        this.setWidth(n);
        this.setHeight(n2);
        return this.me;
    }

    protected T updateDisplayMode(int n) {
        if (n != 0) {
            ControlP5.logger().warning("Image-based or custom displays are not yet implemented for this type of controller. (" + this.getClass().getName() + ")");
        }
        return this.me;
    }

    public T setView(ControllerView<T> controllerView) {
        this.setView(controllerView, 3);
        return this.me;
    }

    public void setView(ControllerView<T> controllerView, int n) {
        this._myDisplayMode = n;
        this._myControllerView = controllerView;
    }

    @Deprecated
    public T setDisplay(ControllerDisplay controllerDisplay) {
        return this.setView(controllerDisplay);
    }

    @Deprecated
    public void setDisplay(ControllerDisplay controllerDisplay, int n) {
        this.setView(controllerDisplay, n);
    }

    @ControlP5.Layout
    public Label getCaptionLabel() {
        return this._myCaptionLabel;
    }

    @ControlP5.Layout
    public Label getValueLabel() {
        return this._myValueLabel;
    }

    @ControlP5.Layout
    public float getMax() {
        return this._myMax;
    }

    @ControlP5.Layout
    public float getMin() {
        return this._myMin;
    }

    @ControlP5.Layout
    public T setMin(float f) {
        this._myMin = f;
        this.changeValue(this.getValue());
        return this.me;
    }

    @ControlP5.Layout
    public T setMax(float f) {
        this._myMax = f;
        this.changeValue(this.getValue());
        return this.me;
    }

    @ControlP5.Layout
    public T setWidth(int n) {
        this.width = n;
        return this.me;
    }

    @ControlP5.Layout
    public T setHeight(int n) {
        this.height = n;
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public int getWidth() {
        return this.width;
    }

    @Override
    @ControlP5.Layout
    public int getHeight() {
        return this.height;
    }

    @ControlP5.Layout
    public T setDecimalPrecision(int n) {
        this._myDecimalPoints = n;
        int[] nArray = this._myValueLabel.getAlign();
        this._myValueLabel = new Label(this.cp5, "" + (this.adjustValue(this._myMax).length() > this.adjustValue(this._myMin).length() ? this.adjustValue(this._myMax) : this.adjustValue(this._myMin)));
        this._myValueLabel.align(nArray);
        this._myValueLabel.setColor(this.color.getValueLabel());
        this._myValueLabel.set("" + this.adjustValue(this.getValue()));
        return this.me;
    }

    @ControlP5.Layout
    public int getDecimalPrecision() {
        return this._myDecimalPoints;
    }

    protected String adjustValue(float f) {
        return this.adjustValue(f, this._myDecimalPoints);
    }

    protected String adjustValue(float f, int n) {
        Object object;
        block6: {
            int n2;
            block5: {
                int n3;
                int n4;
                n2 = n + 1;
                if (this.getControllerPlugList().size() > 0) {
                    object = this.getControllerPlugList().iterator();
                    while (object.hasNext()) {
                        ControllerPlug controllerPlug = object.next();
                        if (controllerPlug.getClassType() != Integer.TYPE) continue;
                        n2 = 0;
                    }
                }
                if ((n4 = ((String)(object = "" + f)).indexOf(46)) <= 0) break block5;
                if (n == 0) {
                    --n4;
                }
                if ((n3 = ((String)(object = ((String)object).substring(0, Math.min(((String)object).length(), n4 + n2)))).length() - n4) >= n2) break block6;
                for (int i = 0; i < n2 - n3; ++i) {
                    object = (String)object + "0";
                }
                break block6;
            }
            object = (String)object + ".";
            for (int i = 0; i < n2; ++i) {
                object = (String)object + "0";
            }
        }
        return object;
    }

    public T align(int n, int n2, int n3, int n4) {
        this.getCaptionLabel().align(n, n2);
        this.getCaptionLabel().align(n3, n4);
        return this.me;
    }

    public ControlWindow getControlWindow() {
        return this._myControlWindow;
    }

    public T lock() {
        this.isLock = true;
        return this.me;
    }

    public T unlock() {
        this.isLock = false;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isLock() {
        return this.isLock;
    }

    @ControlP5.Layout
    public T setLock(boolean bl) {
        this.isLock = bl;
        return this.me;
    }

    @ControlP5.Invisible
    public T setUserInteraction(boolean bl) {
        this.isUserInteraction = bl;
        return this.me;
    }

    @ControlP5.Invisible
    public boolean isUserInteraction() {
        return this.isUserInteraction;
    }

    public T registerTooltip(String string) {
        this.cp5.getTooltip().register(this, string);
        return this.me;
    }

    public T unregisterTooltip() {
        this.cp5.getTooltip().unregister(this);
        return this.me;
    }

    protected T setTooltipEnabled(boolean bl) {
        this.tooltipEnabled = bl;
        return this.me;
    }

    protected boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public T linebreak() {
        this.cp5.linebreak(this, true, autoWidth, autoHeight, autoSpacing);
        return this.me;
    }

    @Override
    public ControllerProperty getProperty(String string) {
        return this.cp5.getProperties().getProperty(this, string);
    }

    @Override
    public ControllerProperty getProperty(String string, String string2) {
        return this.cp5.getProperties().getProperty(this, string, string2);
    }

    @Override
    public T registerProperty(String string) {
        this.cp5.getProperties().register(this, string);
        return this.me;
    }

    @Override
    public T registerProperty(String string, String string2) {
        this.cp5.getProperties().register(this, string, string2);
        return this.me;
    }

    @Override
    public T removeProperty(String string) {
        this.cp5.getProperties().remove((ControllerInterface<?>)this, string);
        return this.me;
    }

    @Override
    public T removeProperty(String string, String string2) {
        this.cp5.getProperties().remove((ControllerInterface<?>)this, string, string2);
        return this.me;
    }

    public String toString() {
        return this.getName() + " [" + this.getClass().getSimpleName() + "]";
    }

    public String getInfo() {
        return "[ type:\tController\nname:\t" + this._myName + "\n" + "label:\t" + this._myCaptionLabel.getText() + "\n" + "id:\t" + this._myId + "\n" + "value:\t" + this.getValue() + "\n" + "arrayvalue:\t" + ControlP5IOHandler.arrayToString(this._myArrayValue) + "\n" + "position:\t" + this.position + "\n" + "absolute:\t" + this.absolutePosition + "\n" + "width:\t" + this.getWidth() + "\n" + "height:\t" + this.getHeight() + "\n" + "color:\t" + this.getColor() + "\n" + "visible:\t" + this.isVisible + "\n" + "moveable:\t" + this.isMoveable + " ]";
    }

    @Deprecated
    public void setSprite(ControllerSprite controllerSprite) {
        this.sprite = controllerSprite;
        this.width = this.sprite.width();
        this.height = this.sprite.height();
        this.enableSprite();
    }

    @Deprecated
    public ControllerSprite getSprite() {
        return this.sprite;
    }

    @Deprecated
    public PVector position() {
        return this.getPosition();
    }

    @Deprecated
    public PVector absolutePosition() {
        return this.getAbsolutePosition();
    }

    @Deprecated
    public void setWindow(PApplet pApplet) {
        this.moveTo(pApplet);
    }

    @Deprecated
    public ControlWindow setWindow(ControlWindow controlWindow) {
        this.moveTo(controlWindow);
        return this._myControlWindow;
    }

    @Deprecated
    public void trigger() {
        this.setValue(this.value());
    }

    @Override
    @Deprecated
    public T setColorLabel(int n) {
        this.setColorCaptionLabel(n);
        return this.me;
    }

    @Override
    @Deprecated
    public T setColorValue(int n) {
        this.setColorValueLabel(n);
        return this.me;
    }

    @Deprecated
    public float value() {
        return this.getValue();
    }

    @Override
    @Deprecated
    public String stringValue() {
        return this.getStringValue();
    }

    @Deprecated
    public float[] arrayValue() {
        return this.getArrayValue();
    }

    @Deprecated
    public float min() {
        return this.getMin();
    }

    @Deprecated
    public float max() {
        return this.getMax();
    }

    @Deprecated
    public CColor color() {
        return this.color;
    }

    @Deprecated
    public ControlBehavior behavior() {
        return this.getBehavior();
    }

    @Deprecated
    public Label captionLabel() {
        return this.getCaptionLabel();
    }

    @Deprecated
    public float defaultValue() {
        return this.getDefaultValue();
    }

    @Deprecated
    public ControlWindow controlWindow() {
        return this._myControlWindow;
    }

    @Deprecated
    public String label() {
        return this._myCaptionLabel.toString();
    }

    @Deprecated
    public T listen() {
        this.listen(true);
        return this.me;
    }

    @Override
    @Deprecated
    public String name() {
        return this.getName();
    }

    @Override
    @Deprecated
    public int id() {
        return this._myId;
    }

    @Override
    @Deprecated
    public T setLabel(String string) {
        this.setCaptionLabel(string);
        return this.me;
    }

    @Deprecated
    public Label valueLabel() {
        return this._myValueLabel;
    }

    @Deprecated
    public void enableSprite() {
        if (this.sprite != null) {
            this.isSprite = true;
            this.updateDisplayMode(2);
        }
    }

    @Deprecated
    public void disableSprite() {
        this.isSprite = false;
        this.updateDisplayMode(0);
    }

    @Deprecated
    public T setAutoUpdate(boolean bl) {
        this.listen(bl);
        return this.me;
    }

    @Deprecated
    protected ControllerPlug controllerPlug(int n) {
        return this._myControllerPlugList.get(n);
    }

    @Override
    @Deprecated
    public ControllerInterface<?> parent() {
        return this._myParent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DebugView
    implements ControllerView<T> {
        DebugView() {
        }

        @Override
        public void display(PApplet pApplet, T t) {
            if (Controller.this.inside()) {
                pApplet.fill(255.0f, 0.0f, 0.0f, 50.0f);
                pApplet.stroke(255.0f, 0.0f, 0.0f);
            } else {
                pApplet.fill(255, 50.0f);
                pApplet.stroke(255);
            }
            pApplet.pushMatrix();
            pApplet.rect(0.0f, 0.0f, (float)Controller.this.width, (float)Controller.this.height);
            pApplet.popMatrix();
        }
    }
}

