/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.Label;
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlGroup<T>
extends ControllerGroup<T>
implements ControlListener {
    protected int _myBackgroundHeight = 0;
    protected int _myBackgroundColor = 0xFFFFFF;
    protected boolean isEventActive = false;
    protected List<ControlListener> _myControlListener = new ArrayList<ControlListener>();

    public ControlGroup(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0, 0, 100, 9);
        controlP5.register(controlP5.papplet, string, this);
    }

    public ControlGroup(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2);
        this._myValueLabel = new Label(this.cp5, "");
        this._myWidth = n3;
        this._myHeight = n4;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        if (this.isBarVisible && this.isCollapse && !this.cp5.keyHandler.isAltDown()) {
            boolean bl = this.isOpen = !this.isOpen;
            if (this.isEventActive) {
                ControlEvent controlEvent = new ControlEvent(this);
                this.cp5.getControlBroadcaster().broadcast(controlEvent, 0);
                for (ControlListener controlListener : this._myControlListener) {
                    controlListener.controlEvent(controlEvent);
                }
            }
        }
    }

    public T activateEvent(boolean bl) {
        this.isEventActive = bl;
        return (T)this.me;
    }

    @Override
    public T setSize(int n, int n2) {
        super.setSize(n, n2);
        this.setBackgroundHeight(n2);
        return (T)this.me;
    }

    public int getBackgroundHeight() {
        return this._myBackgroundHeight;
    }

    public T setBackgroundHeight(int n) {
        this._myBackgroundHeight = n;
        return (T)this.me;
    }

    public T setBackgroundColor(int n) {
        this._myBackgroundColor = n;
        return (T)this.me;
    }

    public T setBarHeight(int n) {
        this._myHeight = n;
        return (T)this.me;
    }

    public int getBarHeight() {
        return this._myHeight;
    }

    @Override
    public T updateInternalEvents(PApplet pApplet) {
        if (this.isInside && this.isBarVisible) {
            this._myControlWindow.setMouseOverController(this);
        }
        return (T)this.me;
    }

    @Override
    protected void preDraw(PApplet pApplet) {
        if (this.isOpen) {
            pApplet.fill(this._myBackgroundColor);
            pApplet.rect(0.0f, 0.0f, (float)this._myWidth, (float)(this._myBackgroundHeight - 1));
        }
    }

    @Override
    protected void postDraw(PApplet pApplet) {
        if (this.isBarVisible) {
            pApplet.fill(this.isInside ? this.color.getForeground() : this.color.getBackground());
            pApplet.rect(0.0f, -1.0f, (float)this._myWidth, (float)(-this._myHeight));
            this._myLabel.draw(pApplet, 0, -this._myHeight, this);
            if (this.isCollapse && this.isArrowVisible) {
                pApplet.fill(this._myLabel.getColor());
                if (this.isOpen) {
                    pApplet.triangle((float)(this._myWidth - 10), (float)(-this._myHeight / 2 - 3), (float)(this._myWidth - 4), (float)(-this._myHeight / 2 - 3), (float)(this._myWidth - 7), (float)(-this._myHeight / 2));
                } else {
                    pApplet.triangle((float)(this._myWidth - 10), (float)(-this._myHeight / 2), (float)(this._myWidth - 4), (float)(-this._myHeight / 2), (float)(this._myWidth - 7), (float)(-this._myHeight / 2 - 3));
                }
            }
        }
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.getController().getName().equals(this.getName() + "close")) {
            this.hide();
        }
    }

    @Override
    @ControlP5.Invisible
    public String stringValue() {
        return Float.toString(this._myValue);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public String getInfo() {
        return "type:\tControlGroup\n" + super.getInfo();
    }

    @Override
    public T addListener(ControlListener controlListener) {
        this._myControlListener.add(controlListener);
        return (T)this.me;
    }

    @Override
    public T removeListener(ControlListener controlListener) {
        this._myControlListener.remove(controlListener);
        return (T)this.me;
    }

    @Override
    public int listenerSize() {
        return this._myControlListener.size();
    }
}

