/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Bang;
import controlP5.ControlElement;
import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerInterface;
import controlP5.DropdownList;
import controlP5.Knob;
import controlP5.ListBox;
import controlP5.Numberbox;
import controlP5.Slider;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ControllerAutomator {
    static Map<Set<Class<?>>, Class<? extends Controller<?>>> mapping = new HashMap();
    static Map<String, Class<? extends ControllerInterface<?>>> types;
    private ControlP5 cp5;

    static Set<Class<?>> makeKey(Class<?> ... classArray) {
        HashSet hashSet = new HashSet();
        for (Class<?> clazz : classArray) {
            hashSet.add(clazz);
        }
        return hashSet;
    }

    ControllerAutomator(ControlP5 controlP5) {
        this.cp5 = controlP5;
    }

    private Object[] getParameters(Class<?>[] classArray, String string) {
        if (classArray[0] == Integer.TYPE) {
            return new Object[]{Integer.parseInt(string)};
        }
        if (classArray[0] == Float.TYPE) {
            return new Object[]{Float.valueOf(Float.parseFloat(string))};
        }
        if (classArray[0] == String.class) {
            return new Object[]{string};
        }
        if (classArray[0] == Boolean.TYPE) {
            return new Object[]{Boolean.parseBoolean(string)};
        }
        return new Object[0];
    }

    void addControllersFor(String string, final Object object) {
        Object[] objectArray;
        Object object2;
        Object[] objectArray2;
        String string22;
        Class<ControllerInterface<?>> clazz;
        HashMap<String, String> hashMap;
        ControlElement controlElement;
        if (object instanceof List) {
            return;
        }
        Class<?> clazz2 = object.getClass();
        Field[] fieldArray = clazz2.getDeclaredFields();
        Method[] methodArray = clazz2.getDeclaredMethods();
        for (Method accessibleObject : methodArray) {
            if (!accessibleObject.isAnnotationPresent(ControlElement.class)) continue;
            controlElement = accessibleObject.getAnnotation(ControlElement.class);
            hashMap = new HashMap<String, String>();
            clazz = null;
            for (String string22 : controlElement.properties()) {
                objectArray2 = string22.split("=");
                if (objectArray2[0].startsWith("type")) {
                    clazz = types.get(objectArray2[1].toLowerCase());
                    continue;
                }
                hashMap.put("set" + ControllerAutomator.capitalize(objectArray2[0]), objectArray2[1]);
            }
            if (clazz == null) {
                clazz = mapping.get(ControllerAutomator.makeKey(accessibleObject.getParameterTypes()));
            }
            if (clazz == null) continue;
            object2 = null;
            if (hashMap.containsKey("setItems")) {
                if (clazz.equals(ListBox.class)) {
                    object2 = this.cp5.addListBox(accessibleObject.getName(), controlElement.x(), controlElement.y(), 100, 100);
                    ((ListBox)object2).addItems(((String)hashMap.get("setItems")).split(","));
                } else if (clazz.equals(DropdownList.class)) {
                    object2 = this.cp5.addDropdownList(accessibleObject.getName(), controlElement.x(), controlElement.y(), 100, 100);
                    ((DropdownList)object2).addItems(((String)hashMap.get("setItems")).split(","));
                }
                try {
                    final Method method = object.getClass().getDeclaredMethod(accessibleObject.getName(), Integer.TYPE);
                    object2.addListener(new ControlListener(){

                        public void controlEvent(ControlEvent controlEvent) {
                            try {
                                method.invoke(object, (int)controlEvent.getValue());
                            }
                            catch (Exception exception) {
                                ControlP5.logger.severe(exception.toString());
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            } else {
                object2 = this.cp5.addController(object, string, accessibleObject.getName(), clazz, controlElement.x(), controlElement.y());
            }
            if (controlElement.label().length() > 0) {
                object2.setCaptionLabel(controlElement.label());
            }
            for (String exception : hashMap.keySet()) {
                string22 = (String)hashMap.get(exception);
                for (Method method : object2.getClass().getMethods()) {
                    if (!method.getName().equals(exception)) continue;
                    try {
                        objectArray = this.getParameters(method.getParameterTypes(), string22);
                        method.invoke(object2, objectArray);
                    }
                    catch (Exception exception2) {
                        ControlP5.logger.severe(exception2.toString());
                    }
                }
            }
        }
        for (AccessibleObject accessibleObject : fieldArray) {
            block40: {
                if (!accessibleObject.isAnnotationPresent(ControlElement.class)) continue;
                controlElement = ((Field)accessibleObject).getAnnotation(ControlElement.class);
                hashMap = new HashMap();
                clazz = null;
                for (String string22 : controlElement.properties()) {
                    objectArray2 = string22.split("=");
                    if (objectArray2[0].startsWith("type")) {
                        clazz = types.get(objectArray2[1].toLowerCase());
                        continue;
                    }
                    hashMap.put("set" + ControllerAutomator.capitalize(objectArray2[0]), objectArray2[1]);
                }
                object2 = null;
                ((Field)accessibleObject).setAccessible(true);
                if (((Field)accessibleObject).getType() == Float.TYPE || ((Field)accessibleObject).getType() == Integer.TYPE) {
                    object2 = clazz == Knob.class ? this.cp5.addKnob(object, string, ((Field)accessibleObject).getName()) : (clazz == Numberbox.class ? this.cp5.addNumberbox(object, string, ((Field)accessibleObject).getName()) : this.cp5.addSlider(object, string, ((Field)accessibleObject).getName()));
                    try {
                        if (((Field)accessibleObject).getType() == Float.TYPE) {
                            object2.setValue(((Field)accessibleObject).getFloat(object));
                            break block40;
                        }
                        object2.setValue(((Field)accessibleObject).getInt(object));
                    }
                    catch (Exception exception) {
                        ControlP5.logger.severe(exception.toString());
                    }
                } else if (((Field)accessibleObject).getType() == String.class) {
                    if (clazz == Textlabel.class) {
                        String string3 = "";
                        try {
                            string3 = "" + ((Field)accessibleObject).get(object);
                            if (((Field)accessibleObject).get(object) == null) {
                                string3 = controlElement.label();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        object2 = this.cp5.addTextlabel(object, string, ((Field)accessibleObject).getName(), string3);
                    } else {
                        object2 = this.cp5.addTextfield(object, string, ((Field)accessibleObject).getName());
                    }
                } else if (((Field)accessibleObject).getType() == Boolean.TYPE) {
                    object2 = this.cp5.addToggle(object, string, ((Field)accessibleObject).getName());
                    try {
                        object2.setValue(((Field)accessibleObject).getBoolean(object) ? 1.0f : 0.0f);
                    }
                    catch (Exception exception) {
                        ControlP5.logger.severe(exception.toString());
                    }
                }
            }
            if (object2 == null) continue;
            if (controlElement.label().length() > 0) {
                object2.setCaptionLabel(controlElement.label());
            }
            object2.setPosition(controlElement.x(), controlElement.y());
            for (String string4 : hashMap.keySet()) {
                string22 = (String)hashMap.get(string4);
                for (Method method : object2.getClass().getMethods()) {
                    if (!method.getName().equals(string4)) continue;
                    try {
                        objectArray = this.getParameters(method.getParameterTypes(), string22);
                        method.invoke(object2, objectArray);
                    }
                    catch (Exception exception) {
                        ControlP5.logger.severe(exception.toString());
                    }
                }
            }
        }
    }

    static String capitalize(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        String[] stringArray = string.split("\\s");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(Character.toUpperCase(stringArray[i].charAt(0))).append(stringArray[i].substring(1));
        }
        return stringBuilder.toString();
    }

    static {
        mapping.put(ControllerAutomator.makeKey(Boolean.TYPE), Toggle.class);
        mapping.put(ControllerAutomator.makeKey(Integer.TYPE), Slider.class);
        mapping.put(ControllerAutomator.makeKey(Float.TYPE), Slider.class);
        mapping.put(ControllerAutomator.makeKey(String.class), Textfield.class);
        types = new HashMap();
        types.put("slider", Slider.class);
        types.put("knob", Knob.class);
        types.put("numberbox", Numberbox.class);
        types.put("toggle", Toggle.class);
        types.put("bang", Bang.class);
        types.put("toggle", Toggle.class);
        types.put("textfield", Textfield.class);
        types.put("label", Textlabel.class);
        types.put("textlabel", Textlabel.class);
        types.put("list", ListBox.class);
        types.put("dropdown", DropdownList.class);
    }
}

