/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.BitFontRenderer;
import controlP5.CColor;
import controlP5.CallbackListener;
import controlP5.ControlBroadcaster;
import controlP5.ControlFont;
import controlP5.ControlKey;
import controlP5.ControlListener;
import controlP5.ControlP5Base;
import controlP5.ControlP5IOHandler;
import controlP5.ControlWindow;
import controlP5.ControlWindowCanvas;
import controlP5.ControlWindowKeyHandler;
import controlP5.ControlWindowKeyListener;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerProperty;
import controlP5.FieldChangedListener;
import controlP5.Tab;
import controlP5.Textfield;
import controlP5.Tooltip;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlP5
extends ControlP5Base {
    @Invisible
    public ControlWindow controlWindow;
    public static final CColor RETRO = new CColor(-16750196, -16763310, -16211249, -1, -1);
    public static final CColor CP5BLUE = new CColor(-16683874, -16632755, -16730902, -1, -1);
    public static final CColor RED = new CColor(-5636096, -10092544, -65536, -1, -1);
    public static final CColor WHITE = new CColor(-1711276033, 0x55FFFFFF, -1, -1, -1);
    @Invisible
    static CColor color = new CColor(CP5BLUE);
    @Invisible
    public ControlWindowKeyHandler keyHandler;
    @Invisible
    public PApplet papplet;
    @Invisible
    public static final String VERSION = "0.7.6";
    @Invisible
    public static boolean isApplet = false;
    public static final int standard58 = 0;
    public static final int standard56 = 1;
    public static final int synt24 = 2;
    public static final int grixel = 3;
    public static boolean DEBUG;
    @Invisible
    public static final Logger logger;
    private Map<String, ControllerInterface<?>> _myControllerMap;
    protected ControlBroadcaster _myControlBroadcaster;
    protected Vector<ControlWindow> controlWindowList = new Vector();
    protected boolean isMoveable = false;
    protected boolean isAutoInitialization = false;
    protected boolean isGlobalControllersAlwaysVisible = true;
    protected ControlP5IOHandler _myControlP5IOHandler;
    protected boolean isTabEventsActive;
    protected boolean isUpdate;
    protected boolean isControlFont;
    protected ControlFont controlFont;
    protected static int bitFont;
    protected boolean isShortcuts = false;
    public boolean blockDraw;
    protected Tooltip _myTooltip;
    protected boolean isAnnotation;
    static int welcome;

    public ControlP5(PApplet pApplet) {
        this.papplet = pApplet;
        this.init();
    }

    public ControlP5(PApplet pApplet, ControlFont controlFont) {
        this.papplet = pApplet;
        this.setFont(controlFont);
        this.init();
    }

    protected void init() {
        new BitFontRenderer(this);
        this.isTabEventsActive = false;
        this._myControlP5IOHandler = new ControlP5IOHandler(this);
        this._myControlBroadcaster = new ControlBroadcaster(this);
        this.keyHandler = new ControlWindowKeyHandler(this);
        this.controlWindow = new ControlWindow(this, this.papplet);
        this.papplet.registerPre((Object)this);
        this.papplet.registerKeyEvent((Object)new ControlWindowKeyListener(this));
        this.papplet.registerDispose((Object)this);
        this._myControllerMap = new TreeMap();
        this.controlWindowList.add(this.controlWindow);
        this._myTooltip = new Tooltip(this);
        super.init(this);
        if (welcome++ < 1) {
            this.welcome();
        }
        this.mapKeyFor(new ControlKey(){

            public void keyEvent() {
                ControlP5.this.saveProperties();
            }
        }, 18, 16, 115);
        this.mapKeyFor(new ControlKey(){

            public void keyEvent() {
                ControlP5.this.loadProperties();
            }
        }, 18, 16, 108);
        this.mapKeyFor(new ControlKey(){

            public void keyEvent() {
                if (ControlP5.this.controlWindow.isVisible) {
                    ControlP5.this.hide();
                } else {
                    ControlP5.this.show();
                }
            }
        }, 18, 16, 104);
    }

    private void welcome() {
        System.out.println("ControlP5 0.7.6 infos, comments, questions at http://www.sojamo.de/libraries/controlP5");
    }

    public void setTabEventsActive(boolean bl) {
        this.isTabEventsActive = bl;
    }

    public void setAutoInitialization(boolean bl) {
        this.isAutoInitialization = bl;
    }

    public void setAutoDraw(boolean bl) {
        if (this.isAutoDraw() && !bl) {
            this.controlWindow.papplet().unregisterDraw((Object)this.controlWindow);
        }
        if (!this.isAutoDraw() && bl) {
            this.controlWindow.papplet().registerDraw((Object)this.controlWindow);
        }
        this.controlWindow.isAutoDraw = bl;
    }

    public boolean isAutoDraw() {
        return this.controlWindow.isAutoDraw;
    }

    public ControlBroadcaster getControlBroadcaster() {
        return this._myControlBroadcaster;
    }

    public ControlP5 addListener(ControlListener ... controlListenerArray) {
        this.getControlBroadcaster().addListener(controlListenerArray);
        return this;
    }

    public ControlP5 removeListener(ControlListener ... controlListenerArray) {
        this.getControlBroadcaster().removeListener(controlListenerArray);
        return this;
    }

    public ControlP5 removeListener(ControlListener controlListener) {
        this.getControlBroadcaster().removeListener(controlListener);
        return this;
    }

    public ControlListener getListener(int n) {
        return this.getControlBroadcaster().getListener(n);
    }

    public ControlP5 addCallback(CallbackListener ... callbackListenerArray) {
        this.getControlBroadcaster().addCallback(callbackListenerArray);
        return this;
    }

    public ControlP5 addCallback(CallbackListener callbackListener) {
        this.getControlBroadcaster().addCallback(callbackListener);
        return this;
    }

    public ControlP5 addCallback(CallbackListener callbackListener, Controller<?> ... controllerArray) {
        this.getControlBroadcaster().addCallback(callbackListener, controllerArray);
        return this;
    }

    public ControlP5 removeCallback(CallbackListener ... callbackListenerArray) {
        this.getControlBroadcaster().removeCallback(callbackListenerArray);
        return this;
    }

    public ControlP5 removeCallback(Controller<?> ... controllerArray) {
        this.getControlBroadcaster().removeCallback(controllerArray);
        return this;
    }

    public ControlP5 removeCallback(Controller<?> controller) {
        this.getControlBroadcaster().removeCallback(controller);
        return this;
    }

    public void addControlsFor(Object object) {
    }

    public Tab getTab(String string) {
        for (int i = 0; i < this.controlWindowList.size(); ++i) {
            for (int j = 0; j < this.controlWindowList.get(i).getTabs().size(); ++j) {
                if (!((Tab)this.controlWindowList.get(i).getTabs().get(j)).getName().equals(string)) continue;
                return (Tab)this.controlWindowList.get(i).getTabs().get(j);
            }
        }
        Tab tab = this.addTab(string);
        return tab;
    }

    public Tab getTab(ControlWindow controlWindow, String string) {
        for (int i = 0; i < controlWindow.getTabs().size(); ++i) {
            if (!((Tab)controlWindow.getTabs().get(i)).getName().equals(string)) continue;
            return (Tab)controlWindow.getTabs().get(i);
        }
        Tab tab = controlWindow.add(new Tab(this, controlWindow, string));
        return tab;
    }

    public ControlP5 register(Object object, String string, ControllerInterface<?> controllerInterface) {
        String string2 = "";
        if (object == this.papplet) {
            string2 = controllerInterface.getName().startsWith("/") ? "" : "/";
            string2 = string2 + controllerInterface.getName();
        } else {
            string2 = string.length() == 0 || string.startsWith("/") ? "" : "/";
            string2 = string2 + string;
            string2 = string2 + (controllerInterface.getName().startsWith("/") ? "" : "/");
            string2 = string2 + controllerInterface.getName();
        }
        controllerInterface.setAddress(string2);
        if (this.checkName(controllerInterface.getAddress())) {
            this.remove(controllerInterface.getAddress());
        }
        this._myControllerMap.put(controllerInterface.getAddress(), controllerInterface);
        List<ControllerProperty> list = this.getProperties().get(controllerInterface);
        if (list != null) {
            for (ControllerProperty controllerProperty : list) {
                controllerProperty.setAddress(controllerInterface.getAddress());
            }
        }
        controllerInterface.init();
        if (controllerInterface instanceof Controller) {
            if (object == null) {
                object = this.papplet;
            }
            if (!object.equals(this.papplet)) {
                ((Controller)((Controller)controllerInterface).unplugFrom(this.papplet)).plugTo(object);
            }
            if (!this._myObjectToControllerMap.containsKey(object)) {
                this._myObjectToControllerMap.put(object, new ArrayList());
            }
            ((ArrayList)this._myObjectToControllerMap.get(object)).add(controllerInterface);
        }
        return this;
    }

    public List<ControllerInterface<?>> getAll() {
        return new ArrayList(this._myControllerMap.values());
    }

    public <T> List<T> getAll(Class<T> clazz) {
        ArrayList arrayList = new ArrayList();
        for (ControllerInterface<?> controllerInterface : this._myControllerMap.values()) {
            if (controllerInterface.getClass() != clazz && controllerInterface.getClass().getSuperclass() != clazz) continue;
            arrayList.add(controllerInterface);
        }
        return arrayList;
    }

    protected void deactivateControllers() {
        if (this.getControllerList() != null) {
            ControllerInterface<?>[] controllerInterfaceArray = this.getControllerList();
            for (int i = 0; i < controllerInterfaceArray.length; ++i) {
                if (!(controllerInterfaceArray[i] instanceof Textfield)) continue;
                ((Textfield)controllerInterfaceArray[i]).setFocus(false);
            }
        }
    }

    private String checkAddress(String string) {
        if (!string.startsWith("/")) {
            return "/" + string;
        }
        return string;
    }

    public void printControllerMap() {
        ArrayList<String> arrayList = new ArrayList<String>();
        System.out.println("============================================");
        for (Map.Entry<String, ControllerInterface<?>> object : this._myControllerMap.entrySet()) {
            String string = object.getKey();
            ControllerInterface<?> controllerInterface = object.getValue();
            arrayList.add(string + " = " + controllerInterface);
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            System.out.println(string);
        }
        System.out.println("============================================");
    }

    protected ControlP5 remove(ControlWindow controlWindow) {
        controlWindow.remove();
        this.controlWindowList.remove(controlWindow);
        return this;
    }

    protected void remove(ControllerInterface<?> controllerInterface) {
        this._myControllerMap.remove(controllerInterface.getAddress());
    }

    public void remove(String string) {
        String string2 = this.checkAddress(string);
        if (this.getController(string2) != null) {
            this.getController(string2).remove();
        }
        if (this.getGroup(string2) != null) {
            this.getGroup(string2).remove();
        }
        for (int i = 0; i < this.controlWindowList.size(); ++i) {
            for (int j = 0; j < this.controlWindowList.get(i).getTabs().size(); ++j) {
                if (!((Tab)this.controlWindowList.get(i).getTabs().get(j)).getAddress().equals(string2)) continue;
                ((Tab)this.controlWindowList.get(i).getTabs().get(j)).remove();
            }
        }
        this._myControllerMap.remove(string2);
    }

    public ControllerInterface<?> get(String string) {
        String string2 = this.checkAddress(string);
        if (this._myControllerMap.containsKey(string2)) {
            return this._myControllerMap.get(string2);
        }
        return null;
    }

    public <C> C get(Class<C> clazz, String string) {
        for (ControllerInterface<?> controllerInterface : this._myControllerMap.values()) {
            if (controllerInterface.getClass() != clazz && controllerInterface.getClass().getSuperclass() != clazz) continue;
            return (C)this.get(string);
        }
        return null;
    }

    @Invisible
    public List<ControllerInterface<?>> getList() {
        LinkedList linkedList = new LinkedList();
        for (ControlWindow controlWindow : this.controlWindowList) {
            linkedList.addAll(controlWindow.getTabs().get());
        }
        linkedList.addAll(this.getAll());
        return linkedList;
    }

    public Controller<?> getController(String string) {
        String string2 = this.checkAddress(string);
        if (this._myControllerMap.containsKey(string2) && this._myControllerMap.get(string2) instanceof Controller) {
            return (Controller)this._myControllerMap.get(string2);
        }
        return null;
    }

    public ControllerGroup<?> getGroup(String string) {
        String string2 = this.checkAddress(string);
        if (this._myControllerMap.containsKey(string2) && this._myControllerMap.get(string2) instanceof ControllerGroup) {
            return (ControllerGroup)this._myControllerMap.get(string2);
        }
        return null;
    }

    private boolean checkName(String string) {
        if (this._myControllerMap.containsKey(this.checkAddress(string))) {
            ControlP5.logger().warning("Controller with name \"" + string + "\" already exists. overwriting reference of existing controller.");
            return true;
        }
        return false;
    }

    public void moveControllersForObject(Object object, ControllerGroup<?> controllerGroup) {
        if (this._myObjectToControllerMap.containsKey(object)) {
            ArrayList arrayList = (ArrayList)this._myObjectToControllerMap.get(object);
            for (ControllerInterface controllerInterface : arrayList) {
                ((Controller)controllerInterface).moveTo(controllerGroup);
            }
        }
    }

    public void move(Object object, ControllerGroup<?> controllerGroup) {
        this.moveControllersForObject(object, controllerGroup);
    }

    protected void clear() {
        try {
            int n;
            for (n = this.controlWindowList.size() - 1; n >= 0; --n) {
                this.controlWindowList.get(n).clear();
            }
            for (n = this.controlWindowList.size() - 1; n >= 0; --n) {
                this.controlWindowList.remove(n);
            }
            this._myControllerMap.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Invisible
    public void pre() {
        Iterator iterator = this._myFieldChangedListenerMap.values().iterator();
        while (iterator.hasNext()) {
            ((FieldChangedListener)iterator.next()).update();
        }
    }

    @Invisible
    public void draw() {
        if (!this.blockDraw) {
            this.controlWindow.draw();
        }
    }

    public ControlWindow getWindow() {
        return this.getWindow(this.papplet);
    }

    public ControlP5 disableMouseWheel() {
        this.getWindow().disableMouseWheel();
        return this;
    }

    public ControlP5 enableMouseWheel() {
        this.getWindow().enableMouseWheel();
        return this;
    }

    public boolean isMouseWheel() {
        return this.getWindow().isMouseWheel();
    }

    public ControlWindow.Pointer getPointer() {
        return this.getWindow(this.papplet).getPointer();
    }

    public boolean isMouseOver() {
        return this.getWindow(this.papplet).isMouseOver();
    }

    public boolean isMouseOver(ControllerInterface<?> controllerInterface) {
        return this.getWindow(this.papplet).isMouseOver(controllerInterface);
    }

    public List<ControllerInterface<?>> getMouseOverList() {
        return this.getWindow(this.papplet).getMouseOverList();
    }

    public ControlWindow getWindow(PApplet pApplet) {
        if (pApplet.equals(this.papplet)) {
            return this.controlWindow;
        }
        return this.controlWindow;
    }

    public ControlWindow getWindow(String string) {
        for (int i = 0; i < this.controlWindowList.size(); ++i) {
            if (!this.controlWindowList.get(i).name().equals(string)) continue;
            return this.controlWindowList.get(i);
        }
        ControlP5.logger().warning("ControlWindow " + string + " does not exist. returning null.");
        return null;
    }

    public ControlP5 addCanvas(ControlWindowCanvas controlWindowCanvas) {
        this.getWindow().addCanvas(controlWindowCanvas);
        return this;
    }

    public ControlP5 setColor(CColor cColor) {
        this.setColorBackground(cColor.getBackground());
        this.setColorForeground(cColor.getForeground());
        this.setColorActive(cColor.getActive());
        this.setColorCaptionLabel(cColor.getCaptionLabel());
        this.setColorValueLabel(cColor.getValueLabel());
        return this;
    }

    public static CColor getColor() {
        return color;
    }

    public ControlP5 setColorActive(int n) {
        color.setActive(n);
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setColorActive(n);
        }
        return this;
    }

    public ControlP5 setColorForeground(int n) {
        color.setForeground(n);
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setColorForeground(n);
        }
        return this;
    }

    public ControlP5 setColorBackground(int n) {
        color.setBackground(n);
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setColorBackground(n);
        }
        return this;
    }

    public ControlP5 setColorCaptionLabel(int n) {
        color.setCaptionLabel(n);
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setColorLabel(n);
        }
        return this;
    }

    public ControlP5 setColorValueLabel(int n) {
        color.setValueLabel(n);
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setColorValue(n);
        }
        return this;
    }

    protected Vector<ControlWindow> getControlWindows() {
        return this.controlWindowList;
    }

    public ControlP5 setMoveable(boolean bl) {
        this.isMoveable = bl;
        return this;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public boolean saveProperties() {
        return this._myProperties.save();
    }

    public boolean saveProperties(String string) {
        return this._myProperties.saveAs(string);
    }

    public boolean saveProperties(String string, String ... stringArray) {
        return this._myProperties.saveAs(string, stringArray);
    }

    public boolean loadProperties() {
        return this._myProperties.load();
    }

    public boolean loadProperties(String string) {
        File file = new File(string = this.checkPropertiesPath(string));
        if (file.exists()) {
            return this._myProperties.load(string);
        }
        file = new File(string = this.checkPropertiesPath(string + ".ser"));
        if (file.exists()) {
            return this._myProperties.load(string);
        }
        logger.info("Properties File " + string + " does not exist.");
        return false;
    }

    String checkPropertiesPath(String string) {
        string = string.startsWith("/") || string.startsWith(".") ? string : this.papplet.sketchPath(string);
        return string;
    }

    @Invisible
    public boolean loadLayout(String string) {
        File file = new File(string = this.checkPropertiesPath(string));
        if (file.exists()) {
            this.getLayout().load(string);
            return true;
        }
        logger.info("Layout File " + string + " does not exist.");
        return false;
    }

    public void saveLayout(String string) {
        this.getLayout().save(string);
    }

    public String version() {
        return VERSION;
    }

    public void show() {
        this.controlWindow.show();
    }

    public ControlP5 setBroadcast(boolean bl) {
        this._myControlBroadcaster.broadcast = bl;
        return this;
    }

    public boolean isVisible() {
        return this.controlWindow.isVisible();
    }

    public void hide() {
        this.controlWindow.hide();
    }

    public void update() {
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.update();
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.setUpdate(bl);
        }
    }

    public boolean setFont(int n) {
        if (!BitFontRenderer.fonts.containsKey(n)) {
            return false;
        }
        bitFont = n;
        this.controlFont = new ControlFont(bitFont);
        this.updateFont(this.controlFont);
        return true;
    }

    public boolean setFont(ControlFont controlFont) {
        this.controlFont = controlFont;
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    public boolean setFont(PFont pFont, int n) {
        this.controlFont = new ControlFont(pFont, n);
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    public boolean setFont(PFont pFont) {
        this.controlFont = new ControlFont(pFont);
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    protected void updateFont(ControlFont controlFont) {
        Enumeration<ControlWindow> enumeration = this.controlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = enumeration.nextElement();
            controlWindow.updateFont(controlFont);
        }
    }

    public ControlFont getFont() {
        return this.controlFont;
    }

    public void disableShortcuts() {
        this.isShortcuts = false;
    }

    public boolean isShortcuts() {
        return this.isShortcuts;
    }

    public void enableShortcuts() {
        this.isShortcuts = true;
    }

    public Tooltip getTooltip() {
        return this._myTooltip;
    }

    public void setTooltip(Tooltip tooltip) {
        this._myTooltip = tooltip;
    }

    public ControllerGroup<?> begin() {
        return this.begin(this.controlWindow.getTab("default"));
    }

    public ControllerGroup<?> begin(ControllerGroup<?> controllerGroup) {
        this.setCurrentPointer(controllerGroup);
        return controllerGroup;
    }

    public ControllerGroup<?> begin(int n, int n2) {
        return this.begin(this.controlWindow.getTab("default"), n, n2);
    }

    public ControllerGroup<?> begin(ControllerGroup<?> controllerGroup, int n, int n2) {
        this.setCurrentPointer(controllerGroup);
        controllerGroup.autoPosition.x = n;
        controllerGroup.autoPosition.y = n2;
        controllerGroup.autoPositionOffsetX = n;
        return controllerGroup;
    }

    public ControllerGroup<?> begin(ControlWindow controlWindow) {
        return this.begin(controlWindow.getTab("default"));
    }

    public ControllerGroup<?> begin(ControlWindow controlWindow, int n, int n2) {
        return this.begin(controlWindow.getTab("default"), n, n2);
    }

    public ControllerGroup<?> end(ControllerGroup<?> controllerGroup) {
        this.releaseCurrentPointer(controllerGroup);
        return controllerGroup;
    }

    public ControllerGroup<?> end() {
        return this.end(this.controlWindow.getTab("default"));
    }

    public void addPositionTo(int n, int n2, List<ControllerInterface<?>> list) {
        PVector pVector = new PVector((float)n, (float)n2);
        for (ControllerInterface<?> controllerInterface : list) {
            controllerInterface.setPosition(PVector.add((PVector)controllerInterface.getPosition(), (PVector)pVector));
        }
    }

    public void addPositionTo(int n, int n2, ControllerInterface<?> ... controllerInterfaceArray) {
        this.addPositionTo(n, n2, Arrays.asList(controllerInterfaceArray));
    }

    public void dispose() {
        if (!isApplet) {
            this.clear();
        }
    }

    public static Logger logger() {
        return logger;
    }

    @Deprecated
    public boolean setControlFont(ControlFont controlFont) {
        return this.setFont(controlFont);
    }

    @Deprecated
    public boolean setControlFont(PFont pFont, int n) {
        return this.setFont(pFont, n);
    }

    @Deprecated
    public boolean setControlFont(PFont pFont) {
        return this.setFont(pFont);
    }

    @Deprecated
    public ControlFont getControlFont() {
        return this.getFont();
    }

    @Deprecated
    public boolean save(String string) {
        ControlP5.logger().info("Saving ControlP5 settings in XML format has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    @Deprecated
    public boolean save() {
        ControlP5.logger().info("Saving ControlP5 settings in XML format has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    @Deprecated
    public boolean load(String string) {
        ControlP5.logger().info("Loading ControlP5 from an XML file has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    @Deprecated
    public void trigger() {
        for (String string : this._myControllerMap.keySet()) {
            if (!(this._myControllerMap.get(string) instanceof Controller)) continue;
            ((Controller)this._myControllerMap.get(string)).trigger();
        }
    }

    @Deprecated
    public void disableKeys() {
        this.isShortcuts = false;
    }

    @Deprecated
    public void enableKeys() {
        this.isShortcuts = true;
    }

    @Deprecated
    public void lock() {
        this.isMoveable = false;
    }

    @Deprecated
    public void unlock() {
        this.isMoveable = true;
    }

    @Deprecated
    protected Vector<ControlWindow> controlWindows() {
        return this.getControlWindows();
    }

    @Deprecated
    public Controller<?> controller(String string) {
        return this.getController(string);
    }

    @Deprecated
    public ControllerGroup<?> group(String string) {
        return this.getGroup(string);
    }

    @Deprecated
    public ControlWindow window(String string) {
        return this.getWindow(string);
    }

    @Deprecated
    public ControlWindow window() {
        return this.getWindow();
    }

    @Deprecated
    public Tab tab(ControlWindow controlWindow, String string) {
        return this.getTab(controlWindow, string);
    }

    @Deprecated
    public ControlWindow window(PApplet pApplet) {
        return this.getWindow(pApplet);
    }

    @Deprecated
    public ControlBroadcaster controlbroadcaster() {
        return this._myControlBroadcaster;
    }

    @Deprecated
    public Tab tab(String string) {
        return this.getTab(string);
    }

    @Deprecated
    public ControllerInterface<?>[] getControllerList() {
        ControllerInterface[] controllerInterfaceArray = new ControllerInterface[this._myControllerMap.size()];
        this._myControllerMap.values().toArray(controllerInterfaceArray);
        return controllerInterfaceArray;
    }

    @Deprecated
    public ControlP5 setColorLabel(int n) {
        return this.setColorCaptionLabel(n);
    }

    @Deprecated
    public ControlP5 setColorValue(int n) {
        return this.setColorValueLabel(n);
    }

    static {
        logger = Logger.getLogger(ControlP5.class.getName());
        bitFont = 0;
        welcome = 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Layout {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Invisible {
    }
}

