/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.BitFontRenderer;
import controlP5.Label;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;

public class ControlFont {
    private FontLabel _myFontLabel;
    public static boolean DEBUG = false;
    public static boolean RENDER_2X;

    public ControlFont(PFont pFont) {
        this(pFont, ControlFont.checkFontSize(pFont));
    }

    private static int checkFontSize(PFont pFont) {
        try {
            return pFont.getFont().getSize();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("ControlP5: could not find font-size details for font " + pFont.getName() + ", use constructor ControlFont(PFont theFont, int theFontSize) to specify the font size.");
            return 10;
        }
    }

    public ControlFont(PFont pFont, int n) {
        this(pFont, n, n + 2);
    }

    public ControlFont(PFont pFont, int n, int n2) {
        this._myFontLabel = new PFontLabel(pFont, n, n2);
    }

    protected ControlFont(int n) {
        this._myFontLabel = new BitFontLabel(n);
    }

    void init(Label label) {
        this._myFontLabel.init(label);
    }

    void adjust(PApplet pApplet, Label label) {
        this.get().adjust(pApplet, label);
    }

    public void draw(PApplet pApplet, Label label) {
        this.get().draw(pApplet, label);
    }

    public FontLabel get() {
        return this._myFontLabel;
    }

    public int getWidth() {
        return this.get().getWidth();
    }

    public int getHeight() {
        return this.get().getHeight();
    }

    public static int getWidthFor(String string, Label label, PApplet pApplet) {
        if (label.getFont().get() instanceof BitFontLabel) {
            BitFontLabel bitFontLabel = (BitFontLabel)label.getFont().get();
            return BitFontRenderer.getWidth(label, bitFontLabel, string);
        }
        PFontLabel pFontLabel = (PFontLabel)label.getFont().get();
        pApplet.textFont(pFontLabel.pfont, (float)pFontLabel.size);
        return (int)pApplet.textWidth(string);
    }

    class PFontLabel
    implements FontLabel {
        PFont pfont;
        List<String> txt;
        String s = "";
        private int top;
        private int bottom;
        private int center;
        private int height;
        private int width;
        private int baseline = 0;
        private int _myTextHeight = 1;
        private int[] offset = new int[2];
        private int size;

        PFontLabel(PFont pFont, int n, int n2) {
            this.pfont = pFont;
            this.size = n;
            this.txt = new ArrayList<String>();
        }

        public void init(Label label) {
        }

        public void setSize(int n) {
            this.size = n;
        }

        public int getSize() {
            return this.size;
        }

        public int getOffset(int n) {
            return this.offset[n];
        }

        public int getTextHeight() {
            return this._myTextHeight;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getCenter() {
            return this.center;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getBaseline() {
            return this.baseline;
        }

        public PFont getFont() {
            return this.pfont;
        }

        public void adjust(PApplet pApplet, Label label) {
            if (label.isChanged()) {
                pApplet.textFont(this.pfont, (float)this.size);
                this.top = -((int)pApplet.textAscent());
                this.bottom = (int)pApplet.textDescent();
                this.center = -((-this.top - this.bottom) / 2);
                this.height = label.isMultiline() ? label.getHeight() : (int)(pApplet.textAscent() + pApplet.textDescent());
                int n = this.width = label.isMultiline() ? label.getWidth() : (int)pApplet.textWidth(label.getTextFormatted());
                if (label.isMultiline()) {
                    this.calculateHeight(pApplet, label);
                }
                label.setChanged(false);
            }
        }

        private void calculateHeight(PApplet pApplet, Label label) {
            this.txt.clear();
            String string = label.getTextFormatted();
            List<String> list = Arrays.asList(string.split("\n"));
            string = "";
            for (String string2 : list) {
                List<String> list2 = Arrays.asList(string2.split("\\s"));
                for (String string3 : list2) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (pApplet.textWidth(stringBuilder.append(string).append(string3).toString()) < (float)this.width) {
                        string = string + string3 + " ";
                        continue;
                    }
                    this.txt.add(string.substring(0, PApplet.max((int)0, (int)(string.length() - 1))));
                    string = string3 + " ";
                }
                this.txt.add(string.substring(0, string.length() - 1));
                string = "";
            }
            if (label.getHeight() % label.getLineHeight() != 0) {
                this.txt.add("");
            }
            this._myTextHeight = PApplet.round((float)(this.txt.size() * label.getLineHeight()));
            int n = PApplet.round((float)(label.getHeight() / label.getLineHeight()));
            int n2 = (int)((float)PApplet.max((int)0, (int)(this.txt.size() - n)) * PApplet.abs((float)label.getOffsetYratio()));
            int n3 = PApplet.min((int)this.txt.size(), (int)n);
            this.s = "";
            for (int i = 0; i < n3; ++i) {
                this.s = this.s + this.txt.get(i + n2) + "\n";
            }
        }

        public int getOverflow() {
            return this._myTextHeight - this.height;
        }

        public void draw(PApplet pApplet, Label label) {
            PFont pFont = pApplet.g.textFont;
            float f = pApplet.g.textSize;
            if (pFont == null) {
                pApplet.textSize(f);
                pFont = pApplet.g.textFont;
            }
            int n = pApplet.g.textAlign;
            pApplet.textFont(this.pfont, (float)this.size);
            pApplet.fill(label.getColor());
            if (label.isMultiline()) {
                pApplet.fill(label.getColor());
                pApplet.textLeading((float)label.getLineHeight());
                pApplet.text(this.s, 0.0f, 0.0f, (float)label.getWidth(), (float)label.getHeight());
            } else {
                pApplet.translate(0.0f, (float)(-this.top + 1));
                this.debug(pApplet, label);
                pApplet.fill(label.getColor());
                pApplet.text(label.getTextFormatted(), 0.0f, 0.0f);
                if (RENDER_2X) {
                    pApplet.text(label.getTextFormatted(), 0.0f, 0.0f);
                }
            }
            pApplet.textFont(pFont, f);
            pApplet.textAlign(n);
        }

        private void debug(PApplet pApplet, Label label) {
            if (DEBUG) {
                pApplet.stroke(0.0f, 255.0f, 0.0f);
                pApplet.line(0.0f, (float)this.getBaseline(), pApplet.textWidth(label.getText()), (float)this.getBaseline());
                pApplet.stroke(0.0f, 0.0f, 255.0f);
                pApplet.line(0.0f, (float)this.getTop(), pApplet.textWidth(label.getText()), (float)this.getTop());
                pApplet.stroke(255.0f, 255.0f, 0.0f);
                pApplet.line(0.0f, (float)this.getBottom(), pApplet.textWidth(label.getText()), (float)this.getBottom());
                pApplet.stroke(255.0f, 0.0f, 0.0f);
                pApplet.line(0.0f, (float)this.getCenter(), pApplet.textWidth(label.getText()), (float)this.getCenter());
                pApplet.stroke(255.0f, 128.0f, 0.0f);
                pApplet.line(0.0f, (float)(this.getTop() / 2), pApplet.textWidth(label.getText()), (float)(this.getTop() / 2));
                pApplet.noStroke();
            }
        }
    }

    class BitFontLabel
    implements FontLabel {
        private int _myFontIndex = 0;
        private PImage _myImage;
        private PImage _myImageMask;
        private Label plabel;
        int changeInSizeThreshold = 0;
        private int top;
        private int bottom;
        private int center;
        private int baseline;
        private int height;
        private int width;
        private int _myTextHeight = 1;
        private int[] offset = new int[2];

        BitFontLabel(int n) {
            this._myFontIndex = n;
        }

        public void init(Label label) {
            this.width = BitFontRenderer.getWidth(label, this);
            this.height = BitFontRenderer.getHeight(this.getFontIndex());
            this.bottom = 3;
            this.top = -this.height + this.bottom;
            this.center = -6 + this.bottom;
            this.baseline = 0;
        }

        public int getSize() {
            return 6;
        }

        public void adjust(PApplet pApplet, Label label) {
            if (this._myImage == null) {
                this.adjustTexture(pApplet, label);
            }
            if (this.changed(this.plabel, label)) {
                if (label.isMultiline()) {
                    this.adjustTexture(pApplet, label);
                    return;
                }
                this.adjustTexture(pApplet, label);
                BitFontRenderer.write(this, label);
            }
        }

        private void calculateHeight(Label label) {
            this._myTextHeight = BitFontRenderer.write(this, label);
            if (label.isMultiline()) {
                int n = (int)((float)(this._myTextHeight - this.height + label.getLineHeight()) * label.getOffsetYratio());
                this.offset[1] = n > 0 ? 0 : n;
            }
        }

        public int getOverflow() {
            return this._myTextHeight - this.height;
        }

        public int getOffset(int n) {
            return this.offset[n];
        }

        public void draw(PApplet pApplet, Label label) {
            pApplet.noStroke();
            pApplet.translate(0.0f, (float)(-this.top));
            this.debug(pApplet, label);
            pApplet.image(this._myImage, 0.0f, (float)this.top);
            this.plabel = label.copy();
        }

        public int getTextHeight() {
            return this._myTextHeight;
        }

        private void debug(PApplet pApplet, Label label) {
            if (DEBUG) {
                pApplet.stroke(0.0f, 255.0f, 0.0f);
                pApplet.line(0.0f, (float)this.getBaseline(), pApplet.textWidth(label.getText()), (float)this.getBaseline());
                pApplet.stroke(0.0f, 0.0f, 255.0f);
                pApplet.line(0.0f, (float)this.getTop(), pApplet.textWidth(label.getText()), (float)this.getTop());
                pApplet.stroke(255.0f, 255.0f, 0.0f);
                pApplet.line(0.0f, (float)this.getBottom(), pApplet.textWidth(label.getText()), (float)this.getBottom());
                pApplet.stroke(255.0f, 0.0f, 0.0f);
                pApplet.line(0.0f, (float)this.getCenter(), pApplet.textWidth(label.getText()), (float)this.getCenter());
                pApplet.noStroke();
            }
        }

        private void adjustTexture(PApplet pApplet, Label label) {
            if (label.isMultiline() || label.isFixedSize()) {
                this.width = label.getWidth();
                this.height = label.getHeight();
            } else {
                this.width = BitFontRenderer.getWidth(label, this);
                this.height = BitFontRenderer.getHeight(this.getFontIndex());
                this.width += this.changeInSizeThreshold;
            }
            this._myImage = pApplet.createImage(this.width, this.height, 2);
            this._myImageMask = pApplet.createImage(this.width, this.height, 1);
            this.calculateHeight(label);
            label.setWidth(this.width);
            label.setHeight(this.height);
            label.setChanged(false);
        }

        private boolean changed(Label label, Label label2) {
            if (label2.isMultiline()) {
                return label2.isChanged();
            }
            if (label == null || label2 == null) {
                return false;
            }
            if (label2.isChanged()) {
                label2.setChanged(false);
                return true;
            }
            return !label.getText().equals(label2.getText());
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getCenter() {
            return this.center;
        }

        public int getBaseline() {
            return this.baseline;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }

        public void setFontIndex(int n) {
            this._myFontIndex = n;
            this._myImage = null;
        }

        public int getFontIndex() {
            return this._myFontIndex;
        }

        public PImage getImage() {
            return this._myImage;
        }

        public PImage getImageMask() {
            return this._myImageMask;
        }
    }

    static interface FontLabel {
        public void adjust(PApplet var1, Label var2);

        public void draw(PApplet var1, Label var2);

        public int getWidth();

        public int getHeight();

        public void init(Label var1);

        public int getCenter();

        public int getTop();

        public int getBottom();

        public int getBaseline();

        public int getTextHeight();

        public int getOverflow();

        public int getOffset(int var1);

        public int getSize();
    }
}

