/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CallbackEvent;
import controlP5.CallbackListener;
import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.Controller;
import controlP5.ControllerPlug;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBroadcaster {
    private int _myControlEventType = -1;
    private ControllerPlug _myControlEventPlug = null;
    private ControllerPlug _myControllerCallbackEventPlug = null;
    private ControlP5 cp5;
    private String _myEventMethod = "controlEvent";
    private String _myControllerCallbackEventMethod = "controlEvent";
    private ArrayList<ControlListener> _myControlListeners;
    private Map<CallbackListener, Controller<?>> _myControllerCallbackListeners;
    private static boolean setPrintStackTrace = true;
    private static boolean ignoreErrorMessage = false;
    private static Map<Class<?>, Field[]> fieldcache = new HashMap();
    private static Map<Class<?>, Method[]> methodcache = new HashMap();
    boolean broadcast = true;

    protected ControlBroadcaster(ControlP5 controlP5) {
        this.cp5 = controlP5;
        this._myControlListeners = new ArrayList();
        this._myControllerCallbackListeners = new ConcurrentHashMap();
        this._myControlEventPlug = ControlBroadcaster.checkObject(this.cp5.papplet, this.getEventMethod(), new Class[]{ControlEvent.class});
        this._myControllerCallbackEventPlug = ControlBroadcaster.checkObject(this.cp5.papplet, this._myControllerCallbackEventMethod, new Class[]{CallbackEvent.class});
        if (this._myControlEventPlug != null) {
            this._myControlEventType = 0;
        }
    }

    public ControlBroadcaster addListener(ControlListener ... controlListenerArray) {
        for (ControlListener controlListener : controlListenerArray) {
            this._myControlListeners.add(controlListener);
        }
        return this;
    }

    public ControlBroadcaster removeListener(ControlListener ... controlListenerArray) {
        for (ControlListener controlListener : controlListenerArray) {
            this._myControlListeners.remove(controlListener);
        }
        return this;
    }

    public ControlListener getListener(int n) {
        if (n < 0 || n >= this._myControlListeners.size()) {
            return null;
        }
        return this._myControlListeners.get(n);
    }

    public int listenerSize() {
        return this._myControlListeners.size();
    }

    public ControlBroadcaster addCallback(CallbackListener ... callbackListenerArray) {
        for (CallbackListener callbackListener : callbackListenerArray) {
            this._myControllerCallbackListeners.put(callbackListener, new EmptyController());
        }
        return this;
    }

    public ControlBroadcaster addCallback(CallbackListener callbackListener) {
        this._myControllerCallbackListeners.put(callbackListener, new EmptyController());
        return this;
    }

    public void addCallback(CallbackListener callbackListener, Controller<?> ... controllerArray) {
        for (Controller<?> controller : controllerArray) {
            this._myControllerCallbackListeners.put(callbackListener, controller);
        }
    }

    public ControlBroadcaster removeCallback(CallbackListener ... callbackListenerArray) {
        for (CallbackListener callbackListener : callbackListenerArray) {
            this._myControllerCallbackListeners.remove(callbackListener);
        }
        return this;
    }

    public ControlBroadcaster removeCallback(CallbackListener callbackListener) {
        this._myControllerCallbackListeners.remove(callbackListener);
        return this;
    }

    public ControlBroadcaster removeCallback(Controller<?> ... controllerArray) {
        for (Controller<?> controller : controllerArray) {
            for (Map.Entry<CallbackListener, Controller<?>> entry : this._myControllerCallbackListeners.entrySet()) {
                if (controller == null || !entry.getValue().equals(controller)) continue;
                this._myControllerCallbackListeners.remove(entry.getKey());
            }
        }
        return this;
    }

    public ControlBroadcaster plug(Object object, String string, String string2) {
        this.plug(object, this.cp5.getController(string), string2);
        return this;
    }

    public ControlBroadcaster plug(Object object, Controller<?> controller, String string) {
        if (controller != null) {
            ControllerPlug controllerPlug = ControlBroadcaster.checkObject(object, string, ControlP5Constants.acceptClassList);
            if (controllerPlug == null) {
                return this;
            }
            if (!controller.checkControllerPlug(controllerPlug)) {
                controller.addControllerPlug(controllerPlug);
            }
            return this;
        }
        return this;
    }

    static Field[] getFieldsFor(Class<?> clazz) {
        if (!fieldcache.containsKey(clazz)) {
            fieldcache.put(clazz, clazz.getDeclaredFields());
        }
        return fieldcache.get(clazz);
    }

    static Method[] getMethodFor(Class<?> clazz) {
        if (!methodcache.containsKey(clazz)) {
            methodcache.put(clazz, clazz.getDeclaredMethods());
        }
        return methodcache.get(clazz);
    }

    protected static ControllerPlug checkObject(Object object, String string, Class<?>[] classArray) {
        int n;
        Class<?> clazz = object.getClass();
        Method[] methodArray = ControlBroadcaster.getMethodFor(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            if (methodArray[i].getParameterTypes().length == 1) {
                if (classArray.length == 1 && classArray[0] == CallbackEvent.class) {
                    ControllerPlug controllerPlug = new ControllerPlug(CallbackEvent.class, object, string, 2, -1);
                    if (controllerPlug.getMethod() == null) {
                        return null;
                    }
                    return controllerPlug;
                }
                if (methodArray[i].getParameterTypes()[0] == ControlP5Constants.controlEventClass) {
                    return new ControllerPlug(ControlEvent.class, object, string, 2, -1);
                }
                for (n = 0; n < classArray.length; ++n) {
                    if (methodArray[i].getParameterTypes()[0] != classArray[n]) continue;
                    return new ControllerPlug(object, string, 0, n, classArray);
                }
                break;
            }
            if (methodArray[i].getParameterTypes().length != 0) break;
            return new ControllerPlug(object, string, 0, -1, classArray);
        }
        Field[] fieldArray = ControlBroadcaster.getFieldsFor(clazz);
        for (n = 0; n < fieldArray.length; ++n) {
            if (!fieldArray[n].getName().equals(string)) continue;
            for (int i = 0; i < classArray.length; ++i) {
                if (fieldArray[n].getType() != classArray[i]) continue;
                return new ControllerPlug(object, string, 1, i, classArray);
            }
            break;
        }
        return null;
    }

    public ControlBroadcaster broadcast(ControlEvent controlEvent, int n) {
        if (this.broadcast) {
            for (ControlListener object : this._myControlListeners) {
                object.controlEvent(controlEvent);
            }
            if (!controlEvent.isTab() && !controlEvent.isGroup() && controlEvent.getController().getControllerPlugList().size() > 0) {
                if (n == 4) {
                    for (ControllerPlug controllerPlug : controlEvent.getController().getControllerPlugList()) {
                        this.callTarget(controllerPlug, controlEvent.getStringValue());
                    }
                } else if (n != 5) {
                    for (ControllerPlug controllerPlug : controlEvent.getController().getControllerPlugList()) {
                        if (controllerPlug.checkType(2)) {
                            this.invokeMethod(controllerPlug.getObject(), controllerPlug.getMethod(), new Object[]{controlEvent});
                            continue;
                        }
                        this.callTarget(controllerPlug, controlEvent.getValue());
                    }
                }
            }
            if (this._myControlEventType == 0) {
                this.invokeMethod(this._myControlEventPlug.getObject(), this._myControlEventPlug.getMethod(), new Object[]{controlEvent});
            }
        }
        return this;
    }

    protected void callTarget(ControllerPlug controllerPlug, float f) {
        if (controllerPlug.checkType(0)) {
            this.invokeMethod(controllerPlug.getObject(), controllerPlug.getMethod(), controllerPlug.getMethodParameter(f));
        } else if (controllerPlug.checkType(1)) {
            this.invokeField(controllerPlug.getObject(), controllerPlug.getField(), controllerPlug.getFieldParameter(f));
        }
    }

    protected void callTarget(ControllerPlug controllerPlug, String string) {
        if (controllerPlug.checkType(0)) {
            this.invokeMethod(controllerPlug.getObject(), controllerPlug.getMethod(), new Object[]{string});
        } else if (controllerPlug.checkType(1)) {
            this.invokeField(controllerPlug.getObject(), controllerPlug.getField(), string);
        }
    }

    private void invokeField(Object object, Field field, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            ControlP5.logger().warning(illegalAccessException.toString());
        }
    }

    private void invokeMethod(Object object, Method method, Object[] objectArray) {
        try {
            if (objectArray[0] == null) {
                method.invoke(object, new Object[0]);
            } else {
                method.invoke(object, objectArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ControlP5.logger().warning(illegalArgumentException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.printMethodError(method, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.printMethodError(method, invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            this.printMethodError(method, nullPointerException);
        }
    }

    protected String getEventMethod() {
        return this._myEventMethod;
    }

    protected void invokeAction(CallbackEvent callbackEvent) {
        for (Map.Entry<CallbackListener, Controller<?>> entry : this._myControllerCallbackListeners.entrySet()) {
            boolean bl = entry.getValue().getClass().equals(EmptyController.class) ? true : entry.getValue().equals(callbackEvent.getController());
            if (!bl) continue;
            entry.getKey().controlEvent(callbackEvent);
        }
        if (this._myControllerCallbackEventPlug != null) {
            this.invokeMethod(this.cp5.papplet, this._myControllerCallbackEventPlug.getMethod(), new Object[]{callbackEvent});
        }
    }

    private void printMethodError(Method method, Exception exception) {
        if (!ignoreErrorMessage) {
            ControlP5.logger().severe("An error occured while forwarding a Controller event, please check your code at " + method.getName() + (!setPrintStackTrace ? " exception:  " + exception : ""));
            if (setPrintStackTrace) {
                exception.printStackTrace();
            }
        }
    }

    public static void ignoreErrorMessage(boolean bl) {
        ignoreErrorMessage = bl;
    }

    public static void setPrintStackTrace(boolean bl) {
        setPrintStackTrace = bl;
    }

    @Deprecated
    public void plug(String string, String string2) {
        this.plug((Object)this.cp5.papplet, string, string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmptyController
    extends Controller<EmptyController> {
        protected EmptyController() {
            this(0, 0);
        }

        protected EmptyController(int n, int n2) {
            super("empty" + (int)(Math.random() * 1000000.0), n, n2);
        }

        @Override
        public EmptyController setValue(float f) {
            return this;
        }
    }
}

