/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.Label;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PImage;

public class BitFontRenderer {
    protected static int numFonts = 4;
    public static final int standard58 = 0;
    public static final int standard56 = 1;
    public static final int synt24 = 2;
    public static final int grixel = 3;
    protected float height;
    protected static Map<Integer, BitFont> fonts;
    private final ControlP5 cp5;

    protected BitFontRenderer(ControlP5 controlP5) {
        this.cp5 = controlP5;
        this.loadFonts();
    }

    private void loadFonts() {
        if (fonts == null) {
            fonts = new HashMap<Integer, BitFont>();
            fonts.put(0, new BitFont(0).setSource("standard58.gif"));
            fonts.put(1, new BitFont(1).setSource("standard56.gif"));
            fonts.put(2, new BitFont(2).setSource("synt24.gif"));
            fonts.put(3, new BitFont(3).setSource("GrixelKyrou9.gif"));
        }
    }

    public static int addBitFont(PImage pImage) {
        ControlP5.logger.info("adding custom bitfonts is disabled with this version of controlP5.");
        return -1;
    }

    protected static BitFont getFont(int n) {
        return fonts.get(n);
    }

    protected static int getPosition(Label label, ControlFont.BitFontLabel bitFontLabel, int n) {
        BitFont bitFont = fonts.get(bitFontLabel.getFontIndex());
        String string = label.getTextFormatted();
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = string.charAt(i) - 32;
            if (n4 < 0 || n4 > 95 || (n3 += bitFont.charWidth[n4] + label.getLetterSpacing()) < n) continue;
            return i;
        }
        return n2;
    }

    public static int getWidth(Label label, ControlFont.BitFontLabel bitFontLabel, String string) {
        return BitFontRenderer.getDimension(label, bitFontLabel, -1, -1, string, 0, string.length())[0];
    }

    public static int getWidth(Label label, ControlFont.BitFontLabel bitFontLabel) {
        return BitFontRenderer.getWidth(label, bitFontLabel, label.getText().length());
    }

    protected static int getWidth(Label label, ControlFont.BitFontLabel bitFontLabel, int n) {
        return BitFontRenderer.getDimension(label, bitFontLabel, -1, -1, label.getTextFormatted(), 0, n)[0];
    }

    protected static int[] getDimension(Label label, ControlFont.BitFontLabel bitFontLabel, String string) {
        return BitFontRenderer.getDimension(label, bitFontLabel, -1, -1, string, 0, string.length());
    }

    protected static int[] getDimension(Label label, ControlFont.BitFontLabel bitFontLabel, int n, int n2, String string, int n3, int n4) {
        int[] nArray = new int[]{0, label.getLineHeight()};
        int n5 = 0;
        BitFont bitFont = fonts.get(bitFontLabel.getFontIndex());
        n4 = PApplet.min((int)string.length(), (int)n4);
        for (int i = n3; i < n4; ++i) {
            int n6 = string.charAt(i) - 32;
            if (n6 >= 0 && n6 <= 95) {
                nArray[0] = nArray[0] + (bitFont.charWidth[n6] + label.getLetterSpacing());
                continue;
            }
            char c = string.charAt(i);
            if (c != '\t' && c != '\n' && c != '\r') {
                ControlP5.logger().warning("You are using a character that is not supported by controlP5's BitFont-Renderer, you could use ControlFont instead (see the ControlP5controlFont example). (" + string.charAt(i) + "," + string.charAt(i) + ")");
                continue;
            }
            if (nArray[0] > n5) {
                n5 = nArray[0];
                nArray[0] = 0;
            }
            if (c != '\n' && c != '\r') continue;
            nArray[1] = nArray[1] + label.getLineHeight();
        }
        nArray[0] = nArray[0] > n5 ? nArray[0] : n5;
        return nArray;
    }

    public static int getHeight(int n) {
        return BitFontRenderer.fonts.get((Object)Integer.valueOf((int)n)).texture.height;
    }

    public static int getHeight(ControlFont.BitFontLabel bitFontLabel) {
        return BitFontRenderer.fonts.get((Object)Integer.valueOf((int)bitFontLabel.getFontIndex())).texture.height;
    }

    private static void putchar(int n, int n2, int n3, int n4, PImage pImage, PImage pImage2, BitFont bitFont) {
        int n5 = pImage.width * pImage.height;
        int n6 = bitFont.charWidth[n] * bitFont.charHeight;
        int n7 = n3 * pImage.width;
        for (int i = 0; i < n6; ++i) {
            int n8 = n2 + i % bitFont.charWidth[n];
            int n9 = n8 + n7 + i / bitFont.charWidth[n] * pImage.width;
            if (bitFont.chars[n][i] != -16777216 || n8 >= pImage.width || n8 < 0 || n9 < 0 || n9 >= n5) continue;
            pImage.pixels[n9] = n4;
            pImage2.pixels[n9] = -1;
        }
    }

    private static int writeCharacters(ControlFont.BitFontLabel bitFontLabel, Label label) {
        int n;
        int n2;
        BitFont bitFont = fonts.get(bitFontLabel.getFontIndex());
        int n3 = 0;
        if (label.isFixedSize()) {
            n2 = BitFontRenderer.getWidth(label, bitFontLabel);
            n3 = n2 > label.getWidth() ? label.getWidth() - n2 : 0;
        }
        n2 = label.getFont().get().getOffset(1);
        int n4 = label.getFont().get().getOffset(1);
        String string = label.getTextFormatted();
        int n5 = label.isMultiline() ? bitFontLabel.getImage().width : -1;
        int n6 = string.length();
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n6];
        int n7 = 0;
        for (n = 0; n < n6; ++n) {
            int n8 = string.charAt(n);
            if (n8 != 10) {
                if (n5 > 0 && n3 > n5) {
                    n3 = 0;
                    n4 += label.getLineHeight();
                    int n9 = n;
                    ++n7;
                    while (n > 0 && n7 < string.length()) {
                        if (--n == 1) {
                            n = n9;
                            break;
                        }
                        if (string.charAt(n) != ' ' && string.charAt(n) != '-') continue;
                        n8 = string.charAt(++n);
                        break;
                    }
                }
                if (n8 >= 127 || n8 <= 32) {
                    n8 = 32;
                }
                nArray[n] = n3;
                nArray2[n] = n8 - 32;
                nArray3[n] = n4;
                n3 += bitFont.charWidth[n8 - 32] + label.getLetterSpacing();
                continue;
            }
            n4 += label.getLineHeight();
            n3 = 0;
            nArray[n] = 0;
            nArray2[n] = -1;
            nArray3[n] = 0;
        }
        for (n = 0; n < n6; ++n) {
            if (nArray2[n] == -1) continue;
            BitFontRenderer.putchar(nArray2[n], nArray[n], nArray3[n], label.getColor(), bitFontLabel.getImage(), bitFontLabel.getImageMask(), bitFont);
        }
        return n4 - n2;
    }

    public static int write(ControlFont.BitFontLabel bitFontLabel, Label label) {
        int n;
        int n2 = bitFontLabel.getImage().width * bitFontLabel.getImage().height;
        for (n = 0; n < n2; ++n) {
            bitFontLabel.getImage().pixels[n] = 0xFFFFFF;
            bitFontLabel.getImageMask().pixels[n] = -16777216;
        }
        n = BitFontRenderer.writeCharacters(bitFontLabel, label);
        bitFontLabel.getImage().mask(bitFontLabel.getImageMask());
        return n;
    }

    @Deprecated
    public static int getWidth(ControlFont.BitFontLabel bitFontLabel) {
        return -1;
    }

    class BitFont {
        protected int characters;
        protected int[] charWidth = new int[255];
        protected int charHeight;
        protected int[][] chars;
        protected int lineHeight;
        protected int wh;
        protected PImage texture;
        protected int id;
        private String _mySource;

        BitFont(int n) {
            this.id = n;
        }

        int getHeight() {
            return this.texture.height;
        }

        BitFont setSource(String string) {
            int n;
            this._mySource = string;
            this.texture = ((BitFontRenderer)BitFontRenderer.this).cp5.papplet.loadImage(this.getClass().getResource(this._mySource).toString());
            this.lineHeight = this.charHeight = this.texture.height;
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < this.texture.width; ++n) {
                ++n2;
                if (this.texture.pixels[n] != -65536) continue;
                this.charWidth[this.characters] = n2;
                ++this.characters;
                if (n2 > n3) {
                    n3 = n2;
                }
                n2 = 0;
            }
            this.chars = new int[this.characters][n3 * this.charHeight];
            n = 0;
            for (int i = 0; i < this.characters; ++i) {
                for (int j = 0; j < this.charWidth[i] * this.charHeight; ++j) {
                    this.chars[i][j] = this.texture.pixels[n + j / this.charWidth[i] * this.texture.width + j % this.charWidth[i]];
                }
                n += this.charWidth[i];
            }
            return this;
        }
    }
}

